package com.js.manage.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycNaturalListReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsKycNaturalService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class JsKycNaturalServiceImpl implements JsKycNaturalService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ApiKycNaturalService apiKycNaturalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;

    @Override
    public String getKycNaturalList(KycNaturalListReq kycNaturalListReq) {
        return apiKycNaturalService.getKycNaturalList(kycNaturalListReq);
    }

    @Override
    public ResponseMessage getKycNatural(String id) {
        KycNaturalVO kycNaturalVO = apiKycNaturalService.getKycNaturaById(id);
        if (ObjectUtil.isNotEmpty(kycNaturalVO)) {
            return ResultUtil.success(kycNaturalVO, ResultEnum.QUERY_SUCCESS);
        } else {
            return ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
    }

    @Override
    public int updateKycNatural(KycNaturalReq kycNaturalReq) {
        return apiKycNaturalService.updateKycNatural(kycNaturalReq);
    }

    @Override
    public int deleteKycNatural(String id) {
        return apiKycNaturalService.deleteKycNaturaById(id);
    }

    @Override
    public ResponseMessage getKycNaturalDetail(String id, RegisterType registerType) {
        JSONObject certiInfo = apiSunrateTradePriceService.findCertiInfo(id, registerType);
        return ResultUtil.success(certiInfo);
    }

    @Override
    public ResponseMessage auditKycNatural(KycNaturalReq kycNaturalReq) {
        if(StringUtils.isNotBlank(kycNaturalReq.getJsRemark()) && kycNaturalReq.getJsRemark().length() > 300){
            log.error("审核备注超长300：{}",kycNaturalReq.getJsRemark().length());
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        return apiKycNaturalService.auditKycNatural(kycNaturalReq);
    }
}
