package com.js.manage.controller;

import cn.hutool.core.util.ObjectUtil;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycNaturalListReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

/**
 *
 * @Author liuty
 * @Description 用户 kyc controller
 * @Date 2019/6/27
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
public class JsKycNaturalController {

    @Autowired
    JsKycNaturalService jsKycNaturalService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/list.html")
    public String listInput() {
        return "kyc_natural/list";
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/view.html")
    public String viewInput(String id, ModelMap model) {
        ResponseMessage kycNatural;
        if(ObjectUtil.isNotEmpty(id)) {
            kycNatural = jsKycNaturalService.getKycNatural(id);
        } else {
            kycNatural = ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        model.addAttribute(kycNatural);
        return "kyc_natural/view";
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/edit.html")
    public String editInput(String id, ModelMap model) {
        ResponseMessage kycNatural = null;
        if(ObjectUtil.isNotEmpty(id)) {
            kycNatural = jsKycNaturalService.getKycNatural(id);
        }
        if(ObjectUtil.isEmpty(kycNatural)) {
            kycNatural = ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        model.addAttribute(kycNatural);
        return "kyc_natural/edit";
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/delete", method = RequestMethod.GET)
    @ResponseBody
    public ResponseMessage delete(String id) {
        if(ObjectUtil.isNotEmpty(id)) {
            int i = jsKycNaturalService.deleteKycNatural(id);
            if (i != 0) {
                return ResultUtil.success(ResultEnum.DELETE_SUCCESS);
            } else {
                return ResultUtil.error(ResultEnum.DELETE_ERROR);
            }
        } else {
            return ResultUtil.error(ResultEnum.DELETE_ERROR);
        }
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/save", method = RequestMethod.POST)
    @ResponseBody
    public ResponseMessage save(KycNaturalReq kycNaturalReq) {
        if (ObjectUtil.isNotEmpty(kycNaturalReq.getId())) {
            if (ObjectUtil.isEmpty(kycNaturalReq.getEmailActiveFlag())) {
                kycNaturalReq.setEmailActiveFlag(false);
            }
            if (ObjectUtil.isEmpty(kycNaturalReq.getRecordFlag())) {
                kycNaturalReq.setRecordFlag(false);
            }
            int i = jsKycNaturalService.updateKycNatural(kycNaturalReq);
            if (i != 0) {
                return ResultUtil.success(ResultEnum.UPDATE_SUCCESS);
            } else {
                return ResultUtil.error(ResultEnum.UPDATE_ERROR);
            }
        } else {
            return ResultUtil.error(ResultEnum.SAVE_ERROR.getCode(), "后台不允许添加用户");
        }
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsNatural/getKycNaturalList")
    @ResponseBody
    public String getKycNaturalList(KycNaturalListReq kycNaturalListReq) {
        return jsKycNaturalService.getKycNaturalList(kycNaturalListReq);
    }
}
