package com.js.manage.controller;

import cn.hutool.core.util.ObjectUtil;
import com.js.api.jspay.service.ApiKycBankService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycBankCardReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 *
 * TODO 需要重构。
 * @Author liuty
 * @Description 用户银行卡 controller
 * @Date 2019/5/25
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
public class JsKycBankController {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    ApiKycBankService apiKycBankService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsBank/list.html")
    public String listInput() {
        return "kyc_bank/list";
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsBank/view.html")
    public String viewInput(String id, ModelMap model) {
        ResponseMessage bankCard;
        if(ObjectUtil.isNotEmpty(id)) {
            bankCard = apiKycBankService.getBankCard(id);
        } else {
            bankCard = ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        model.addAttribute(bankCard);
        return "kyc_bank/view";
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsBank/getBank")
    @ResponseBody
    public ResponseMessage getBankCard(String id) {
        return apiKycBankService.getBankCard(id);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsBank/getBankList")
    @ResponseBody
    public String getBankCardList(KycBankCardReq kycBankCardReq) {
        return apiKycBankService.getBankCardList(kycBankCardReq);
    }
}
