package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "platform_amazon_risk_quota")
public class PlatformAmazonRiskQuota extends IBaseModel implements Serializable {
    /**
     * 用户 id
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 授权成功的店铺数量
     */
    @Column(name = "auth_and_auth_with_account_num")
    private Integer authAndAuthWithAccountNum;

    /**
     * 亚马逊美国店铺近半年销售额占比（授权成功）
     */
    @Column(name = "amazon_us_sale_ratio")
    private BigDecimal amazonUsSaleRatio;

    /**
     * 授权成功店铺月均销售额（美元）
     */
    @Column(name = "monthly_sale")
    private BigDecimal monthlySale;

    /**
     * 退款率环比波动率
     */
    @Column(name = "refund_chain_rate")
    private BigDecimal refundChainRate;

    /**
     * 在售商品数量环比波动率
     */
    @Column(name = "available_product_num_chain_rate")
    private BigDecimal availableProductNumChainRate;

    /**
     * 绑定回款账户与授权店铺的比例
     */
    @Column(name = "auth_with_account_and_auth_ratio")
    private BigDecimal authWithAccountAndAuthRatio;

    /**
     * 销售额前10名商品占比
     */
    @Column(name = "sales_top_ten_ratio")
    private BigDecimal salesTopTenRatio;

    /**
     * 销售额前3名商品占比
     */
    @Column(name = "sales_top_three_ratio")
    private BigDecimal salesTopThreeRatio;

    /**
     * 月均入账金额（美元）
     */
    @Column(name = "monthly_income")
    private BigDecimal monthlyIncome;

    /**
     * 绑定回款账户时长(单位月)
     */
    @Column(name = "bind_time")
    private Integer bindTime;

    /**
     * 近一个月入账金额环比增长率
     */
    @Column(name = "income_chain_rate")
    private BigDecimal incomeChainRate;

    /**
     * 近一个月入账金额与前3个月平均入账金额比例
     */
    @Column(name = "income_three_ratio")
    private BigDecimal incomeThreeRatio;

    /**
     * 近一个月入账金额与前6个月平均入账金额比例
     */
    @Column(name = "income_six_ratio")
    private BigDecimal incomeSixRatio;

    /**
     * 入账金额同比增长率
     */
    @Column(name = "income_growth_rate_on_year")
    private BigDecimal incomeGrowthRateOnYear;

    /**
     * 近一月内笔均入账金额
     */
    @Column(name = "average_income")
    private BigDecimal averageIncome;

    /**
     * 统计时间
     */
    @Column(name = "statistics_time")
    private Date statisticsTime;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PlatformAmazonRiskQuota other = (PlatformAmazonRiskQuota) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getAuthAndAuthWithAccountNum() == null ? other.getAuthAndAuthWithAccountNum() == null : this.getAuthAndAuthWithAccountNum().equals(other.getAuthAndAuthWithAccountNum()))
            && (this.getAmazonUsSaleRatio() == null ? other.getAmazonUsSaleRatio() == null : this.getAmazonUsSaleRatio().equals(other.getAmazonUsSaleRatio()))
            && (this.getMonthlySale() == null ? other.getMonthlySale() == null : this.getMonthlySale().equals(other.getMonthlySale()))
            && (this.getRefundChainRate() == null ? other.getRefundChainRate() == null : this.getRefundChainRate().equals(other.getRefundChainRate()))
            && (this.getAvailableProductNumChainRate() == null ? other.getAvailableProductNumChainRate() == null : this.getAvailableProductNumChainRate().equals(other.getAvailableProductNumChainRate()))
            && (this.getAuthWithAccountAndAuthRatio() == null ? other.getAuthWithAccountAndAuthRatio() == null : this.getAuthWithAccountAndAuthRatio().equals(other.getAuthWithAccountAndAuthRatio()))
            && (this.getSalesTopTenRatio() == null ? other.getSalesTopTenRatio() == null : this.getSalesTopTenRatio().equals(other.getSalesTopTenRatio()))
            && (this.getSalesTopThreeRatio() == null ? other.getSalesTopThreeRatio() == null : this.getSalesTopThreeRatio().equals(other.getSalesTopThreeRatio()))
            && (this.getMonthlyIncome() == null ? other.getMonthlyIncome() == null : this.getMonthlyIncome().equals(other.getMonthlyIncome()))
            && (this.getBindTime() == null ? other.getBindTime() == null : this.getBindTime().equals(other.getBindTime()))
            && (this.getIncomeChainRate() == null ? other.getIncomeChainRate() == null : this.getIncomeChainRate().equals(other.getIncomeChainRate()))
            && (this.getIncomeThreeRatio() == null ? other.getIncomeThreeRatio() == null : this.getIncomeThreeRatio().equals(other.getIncomeThreeRatio()))
            && (this.getIncomeSixRatio() == null ? other.getIncomeSixRatio() == null : this.getIncomeSixRatio().equals(other.getIncomeSixRatio()))
            && (this.getIncomeGrowthRateOnYear() == null ? other.getIncomeGrowthRateOnYear() == null : this.getIncomeGrowthRateOnYear().equals(other.getIncomeGrowthRateOnYear()))
            && (this.getAverageIncome() == null ? other.getAverageIncome() == null : this.getAverageIncome().equals(other.getAverageIncome()))
            && (this.getStatisticsTime() == null ? other.getStatisticsTime() == null : this.getStatisticsTime().equals(other.getStatisticsTime()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getAuthAndAuthWithAccountNum() == null) ? 0 : getAuthAndAuthWithAccountNum().hashCode());
        result = prime * result + ((getAmazonUsSaleRatio() == null) ? 0 : getAmazonUsSaleRatio().hashCode());
        result = prime * result + ((getMonthlySale() == null) ? 0 : getMonthlySale().hashCode());
        result = prime * result + ((getRefundChainRate() == null) ? 0 : getRefundChainRate().hashCode());
        result = prime * result + ((getAvailableProductNumChainRate() == null) ? 0 : getAvailableProductNumChainRate().hashCode());
        result = prime * result + ((getAuthWithAccountAndAuthRatio() == null) ? 0 : getAuthWithAccountAndAuthRatio().hashCode());
        result = prime * result + ((getSalesTopTenRatio() == null) ? 0 : getSalesTopTenRatio().hashCode());
        result = prime * result + ((getSalesTopThreeRatio() == null) ? 0 : getSalesTopThreeRatio().hashCode());
        result = prime * result + ((getMonthlyIncome() == null) ? 0 : getMonthlyIncome().hashCode());
        result = prime * result + ((getBindTime() == null) ? 0 : getBindTime().hashCode());
        result = prime * result + ((getIncomeChainRate() == null) ? 0 : getIncomeChainRate().hashCode());
        result = prime * result + ((getIncomeThreeRatio() == null) ? 0 : getIncomeThreeRatio().hashCode());
        result = prime * result + ((getIncomeSixRatio() == null) ? 0 : getIncomeSixRatio().hashCode());
        result = prime * result + ((getIncomeGrowthRateOnYear() == null) ? 0 : getIncomeGrowthRateOnYear().hashCode());
        result = prime * result + ((getAverageIncome() == null) ? 0 : getAverageIncome().hashCode());
        result = prime * result + ((getStatisticsTime() == null) ? 0 : getStatisticsTime().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}