package com.js.dal.dao.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import com.js.common.enums.HolType;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_system_holiday")
public class JsSystemHoliday extends IBaseModel implements Serializable {
    /**
     * 节假日日期
     */
    @Column(name = "hol_date")
    private Date holDate;

    /**
     * 类型：HOLIDAYS 节假日 WORKING_DAYS 工作日
     */
    @Column(name = "hol_type")
    private HolType holType;

    /**
     * 描述
     */
    @Column(name = "hol_desc")
    private String holDesc;

    /**
     * 备用字段1
     */
    private String backup1;

    /**
     * 备用字段2
     */
    private String backup2;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsSystemHoliday other = (JsSystemHoliday) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getHolDate() == null ? other.getHolDate() == null : this.getHolDate().equals(other.getHolDate()))
            && (this.getHolType() == null ? other.getHolType() == null : this.getHolType().equals(other.getHolType()))
            && (this.getHolDesc() == null ? other.getHolDesc() == null : this.getHolDesc().equals(other.getHolDesc()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getBackup1() == null ? other.getBackup1() == null : this.getBackup1().equals(other.getBackup1()))
            && (this.getBackup2() == null ? other.getBackup2() == null : this.getBackup2().equals(other.getBackup2()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getHolDate() == null) ? 0 : getHolDate().hashCode());
        result = prime * result + ((getHolType() == null) ? 0 : getHolType().hashCode());
        result = prime * result + ((getHolDesc() == null) ? 0 : getHolDesc().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getBackup1() == null) ? 0 : getBackup1().hashCode());
        result = prime * result + ((getBackup2() == null) ? 0 : getBackup2().hashCode());
        return result;
    }
}