package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_public_common_code")
public class JsPublicCommonCode implements Serializable {

    private String id;
    private String code;

    private String name;

    @Column(name = "mapping_code")
    private String mappingCode;

    @Column(name = "mapping_name")
    private String mappingName;

    /**
     * 010启用020停用
     */
    private String status;

    /**
     * 010汇付银行代码映射020小贷银行代码映射
     */
    private String type;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPublicCommonCode other = (JsPublicCommonCode) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getCode() == null ? other.getCode() == null : this.getCode().equals(other.getCode()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getMappingCode() == null ? other.getMappingCode() == null : this.getMappingCode().equals(other.getMappingCode()))
            && (this.getMappingName() == null ? other.getMappingName() == null : this.getMappingName().equals(other.getMappingName()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getType() == null ? other.getType() == null : this.getType().equals(other.getType()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getCode() == null) ? 0 : getCode().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getMappingCode() == null) ? 0 : getMappingCode().hashCode());
        result = prime * result + ((getMappingName() == null) ? 0 : getMappingName().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getType() == null) ? 0 : getType().hashCode());
        return result;
    }
}