package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_vat_payment_info")
public class JsPayVatPaymentInfo extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 缴税人姓名
     */
    @Column(name = "kyc_natural_name")
    private String kycNaturalName;

    /**
     * 浏览器IP
     */
    @Column(name = "browser_ip")
    private String browserIP;

    /**
     * 手机号
     */
    private String phone;
    /**
     * 店铺ID
     */
    @Column(name = "store_id")
    private String storeId;
    /**
     * 店铺编号
     */
    @Column(name = "sub_acct_no")
    private String subAcctNo;

    /**
     * 组织机构代码
     */
    @Column(name = "org_code")
    private String orgCode;
    /**
     * 受益人编号
     */
    @Column(name = "beneficiary_id")
    private String beneficiaryId;
    /**
     * 税局机构id
     */
    @Column(name = "tax_station_id")
    private String taxStationId;

    /**
     * 税局机构名称
     */
    @Column(name = "tax_station_name")
    private String taxStationName;

    /**
     * 缴税金额
     */
    @Column(name = "vat_pay_amt")
    private BigDecimal vatPayAmt;

    /**
     * 缴税金额币种
     */
    @Column(name = "vat_pay_cur")
    private String vatPayCur;

    /**
     * 增值税注册号
     */
    @Column(name = "vat_registe_no")
    private String vatRegisteNo;

    /**
     * 锁汇流水号
     */
    @Column(name = "lock_no")
    private String lockNo;

    /**
     * 缴税寻汇流水号
     */
    @Column(name = "txn_no")
    private String txnNo;

    /**
     * 手续费金额
     */
    @Column(name = "fee_amt")
    private BigDecimal feeAmt;

    /**
     * 手续费币种
     */
    @Column(name = "fee_cur")
    private String feeCur;

    /**
     * 成交汇率
     */
    @Column(name = "fin_rate")
    private BigDecimal finRate;

    /**
     * 出账金额
     */
    @Column(name = "pay_amt")
    private BigDecimal payAmt;

    /**
     * 出账币种
     */
    @Column(name = "pay_cur")
    private String payCur;

    /**
     * 缴税状态 [A0 审核中 A2 审核通过 A3 审核失败 B1 入账失败 B2 入账成功 S1 出账失败 S2 出账成功]
     */
    private String status;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPayVatPaymentInfo other = (JsPayVatPaymentInfo) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKycNaturalName() == null ? other.getKycNaturalName() == null : this.getKycNaturalName().equals(other.getKycNaturalName()))
            && (this.getPhone() == null ? other.getPhone() == null : this.getPhone().equals(other.getPhone()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getSubAcctNo() == null ? other.getSubAcctNo() == null : this.getSubAcctNo().equals(other.getSubAcctNo()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getBeneficiaryId() == null ? other.getBeneficiaryId() == null : this.getBeneficiaryId().equals(other.getBeneficiaryId()))
            && (this.getTaxStationId() == null ? other.getTaxStationId() == null : this.getTaxStationId().equals(other.getTaxStationId()))
            && (this.getTaxStationName() == null ? other.getTaxStationName() == null : this.getTaxStationName().equals(other.getTaxStationName()))
            && (this.getVatPayAmt() == null ? other.getVatPayAmt() == null : this.getVatPayAmt().equals(other.getVatPayAmt()))
            && (this.getVatPayCur() == null ? other.getVatPayCur() == null : this.getVatPayCur().equals(other.getVatPayCur()))
            && (this.getVatRegisteNo() == null ? other.getVatRegisteNo() == null : this.getVatRegisteNo().equals(other.getVatRegisteNo()))
            && (this.getLockNo() == null ? other.getLockNo() == null : this.getLockNo().equals(other.getLockNo()))
            && (this.getTxnNo() == null ? other.getTxnNo() == null : this.getTxnNo().equals(other.getTxnNo()))
            && (this.getFeeAmt() == null ? other.getFeeAmt() == null : this.getFeeAmt().equals(other.getFeeAmt()))
            && (this.getFeeCur() == null ? other.getFeeCur() == null : this.getFeeCur().equals(other.getFeeCur()))
            && (this.getFinRate() == null ? other.getFinRate() == null : this.getFinRate().equals(other.getFinRate()))
            && (this.getPayAmt() == null ? other.getPayAmt() == null : this.getPayAmt().equals(other.getPayAmt()))
            && (this.getPayCur() == null ? other.getPayCur() == null : this.getPayCur().equals(other.getPayCur()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getBrowserIP() == null ? other.getBrowserIP() == null : this.getBrowserIP().equals(other.getBrowserIP()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKycNaturalName() == null) ? 0 : getKycNaturalName().hashCode());
        result = prime * result + ((getPhone() == null) ? 0 : getPhone().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getSubAcctNo() == null) ? 0 : getSubAcctNo().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getBeneficiaryId() == null) ? 0 : getBeneficiaryId().hashCode());
        result = prime * result + ((getTaxStationId() == null) ? 0 : getTaxStationId().hashCode());
        result = prime * result + ((getTaxStationName() == null) ? 0 : getTaxStationName().hashCode());
        result = prime * result + ((getVatPayAmt() == null) ? 0 : getVatPayAmt().hashCode());
        result = prime * result + ((getVatPayCur() == null) ? 0 : getVatPayCur().hashCode());
        result = prime * result + ((getVatRegisteNo() == null) ? 0 : getVatRegisteNo().hashCode());
        result = prime * result + ((getLockNo() == null) ? 0 : getLockNo().hashCode());
        result = prime * result + ((getTxnNo() == null) ? 0 : getTxnNo().hashCode());
        result = prime * result + ((getFeeAmt() == null) ? 0 : getFeeAmt().hashCode());
        result = prime * result + ((getFeeCur() == null) ? 0 : getFeeCur().hashCode());
        result = prime * result + ((getFinRate() == null) ? 0 : getFinRate().hashCode());
        result = prime * result + ((getPayAmt() == null) ? 0 : getPayAmt().hashCode());
        result = prime * result + ((getPayCur() == null) ? 0 : getPayCur().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getBrowserIP() == null) ? 0 : getBrowserIP().hashCode());
        return result;
    }
}