package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "ali_waihui")
public class AliWaihui extends IBaseModel implements Serializable {
    /**
     * 锁汇表主键
     */
    @Column(name = "lock_no")
    private String lockNo;

    /**
     * 现汇买入价
     */
    @Column(name = "hui_in")
    private BigDecimal huiIn;

    /**
     * 现汇卖出价
     */
    @Column(name = "hui_out")
    private BigDecimal huiOut;

    /**
     * 中行折算价
     */
    @Column(name = "zhe_suan")
    private BigDecimal zheSuan;

    /**
     * 货币简码
     */
    private String code;

    /**
     * 货币名称
     */
    private String name;

    /**
     * 现钞买入价
     */
    @Column(name = "chao_in")
    private BigDecimal chaoIn;

    /**
     * 现钞卖出价
     */
    @Column(name = "chao_out")
    private BigDecimal chaoOut;

    /**
     * 发布时间
     */
    @Column(name = "publish_dts")
    private Date publishDts;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        AliWaihui other = (AliWaihui) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getLockNo() == null ? other.getLockNo() == null : this.getLockNo().equals(other.getLockNo()))
            && (this.getHuiIn() == null ? other.getHuiIn() == null : this.getHuiIn().equals(other.getHuiIn()))
            && (this.getHuiOut() == null ? other.getHuiOut() == null : this.getHuiOut().equals(other.getHuiOut()))
            && (this.getZheSuan() == null ? other.getZheSuan() == null : this.getZheSuan().equals(other.getZheSuan()))
            && (this.getCode() == null ? other.getCode() == null : this.getCode().equals(other.getCode()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getChaoIn() == null ? other.getChaoIn() == null : this.getChaoIn().equals(other.getChaoIn()))
            && (this.getChaoOut() == null ? other.getChaoOut() == null : this.getChaoOut().equals(other.getChaoOut()))
            && (this.getPublishDts() == null ? other.getPublishDts() == null : this.getPublishDts().equals(other.getPublishDts()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getLockNo() == null) ? 0 : getLockNo().hashCode());
        result = prime * result + ((getHuiIn() == null) ? 0 : getHuiIn().hashCode());
        result = prime * result + ((getHuiOut() == null) ? 0 : getHuiOut().hashCode());
        result = prime * result + ((getZheSuan() == null) ? 0 : getZheSuan().hashCode());
        result = prime * result + ((getCode() == null) ? 0 : getCode().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getChaoIn() == null) ? 0 : getChaoIn().hashCode());
        result = prime * result + ((getChaoOut() == null) ? 0 : getChaoOut().hashCode());
        result = prime * result + ((getPublishDts() == null) ? 0 : getPublishDts().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}