package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.js.common.enums.JsPaySysAcctTypeEnum;
import com.js.common.enums.SysPlateformType;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_sys_acct")
public class JsPaySysAcct extends IBaseModel implements Serializable {
    /**
     * 平台类型（HFGJ(汇付国际))
     */
    @Column(name = "plateform_type")
    private SysPlateformType plateformType;

    /**
     * 账户类型
     */
    @Column(name = "acct_type")
    private JsPaySysAcctTypeEnum acctType;


    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 用户ID
     */
    @Column(name = "user_id")
    private String userId;

    /**
     * 账户名称
     */
    @Column(name = "acct_name")
    private String acctName;

    /**
     * 账户号
     */
    @Column(name = "acct_no")
    private String acctNo;

    /**
     * 证件号
     */
    @Column(name = "id_no")
    private String idNo;

    /**
     * '收款银行名称'
     */
    @Column(name = "receiving_bank_name")
    private String receivingBankName;

    /**
     * '收款银行地址'
     */
    @Column(name = "receiving_bank_addr")
    private String receivingBankAddr;

    /**
     * '收款人地址'
     */
    @Column(name = "receiving_acct_addr")
    private String receivingAcctAddr;

    /**
     * 'swiftcode'
     */
    @Column(name = "swift_code")
    private String swiftCode;

    /**
     * '收款人常驻国家'
     */
    @Column(name = "receiving_acct_country")
    private String receivingAcctCountry;

    /**
     * '收款账户信息'
     */
    @Column(name = "receiving_acct_desc")
    private String receivingAcctDesc;

    /**
     * '币种
     */
    @Column(name = "cur")
    private String cur;

    /**
     * 账户余额
     */
    @Column(name = "available_amt")
    private BigDecimal availableAmt;

    /**
     * 冻结金额
     */
    @Column(name = "frozen_amt")
    private BigDecimal frozenAmt;

    /**
     * 昨日余额
     */
    @Column(name = "last_amt")
    private BigDecimal lastAmt;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySysAcct other = (JsPaySysAcct) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getAcctType() == null ? other.getAcctType() == null : this.getAcctType().equals(other.getAcctType()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getAcctName() == null ? other.getAcctName() == null : this.getAcctName().equals(other.getAcctName()))
            && (this.getAcctNo() == null ? other.getAcctNo() == null : this.getAcctNo().equals(other.getAcctNo()))
            && (this.getAvailableAmt() == null ? other.getAvailableAmt() == null : this.getAvailableAmt().equals(other.getAvailableAmt()))
            && (this.getFrozenAmt() == null ? other.getFrozenAmt() == null : this.getFrozenAmt().equals(other.getFrozenAmt()))
            && (this.getLastAmt() == null ? other.getLastAmt() == null : this.getLastAmt().equals(other.getLastAmt()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getAcctType() == null) ? 0 : getAcctType().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getAcctName() == null) ? 0 : getAcctName().hashCode());
        result = prime * result + ((getAcctNo() == null) ? 0 : getAcctNo().hashCode());
        result = prime * result + ((getAvailableAmt() == null) ? 0 : getAvailableAmt().hashCode());
        result = prime * result + ((getFrozenAmt() == null) ? 0 : getFrozenAmt().hashCode());
        result = prime * result + ((getLastAmt() == null) ? 0 : getLastAmt().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}