package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_sunrate_trade_lock_price_pre")
public class JsPaySunrateTradeLockPricePre extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 锁汇表主键ID
     */
    @Column(name = "lock_price_id")
    private String lockPriceId;

    /**
     * 寻汇用户表主键ID
     */
    @Column(name = "kyc_sunrate_store_id")
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    @Column(name = "kyc_sunrate_bank_id")
    private String kycSunrateBankId;

    /**
     * 锁汇流水号
     */
    @Column(name = "transin_notice_id")
    private String transinNoticeId;

    /**
     * 店铺ID
     */
    @Column(name = "sub_acct_no")
    private String subAcctNo;

    /**
     * 组织结构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 买入币种
     */
    @Column(name = "buy_cur")
    private String buyCur;

    /**
     * 买入金额
     */
    @Column(name = "buy_amt")
    private BigDecimal buyAmt;

    /**
     * 卖出币种
     */
    @Column(name = "sell_cur")
    private String sellCur;

    /**
     * 卖出金额
     */
    @Column(name = "sell_amt")
    private BigDecimal sellAmt;

    /**
     * 受益人编号
     */
    @Column(name = "beneficiary_id")
    private String beneficiaryId;

    /**
     * 交易模式
     */
    @Column(name = "txn_mode")
    private String txnMode;

    /**
     * 交易金额
     */
    @Column(name = "txn_amt")
    private BigDecimal txnAmt;

    /**
     * 备注
     */
    private String remark;

    /**
     * 交易方式（REPAYMENT-还款，WITHDRAW-提现）
     */
    @Column(name = "trade_type")
    private TradeTypeEnum tradeType;

    /**
     * 交易子类型
     */
    @Column(name = "trade_sub_type")
    private TradeSubTypeEnum tradeSubType;

    /**
     * 银行卡信息主键ID
     */
    @Column(name = "kyc_bank_id")
    private String kycBankId;

    /**
     * 银行账号
     */
    @Column(name = "bank_no")
    private String bankNo;

    @Column(name = "loan_no")
    private String loanNo;

    /**
     * 提交锁汇后虚拟账户可用余额
     */
    @Column(name = "sunrate_bank_available_balance")
    private BigDecimal sunrateBankAvailableBalance;

    /**
     * 当前余额
     */
    @Column(name = "sunrate_bank_current_balance")
    private BigDecimal sunrateBankCurrentBalance;

    /**
     * 批量产生锁汇交易时的批次号
     */
    @Column(name = "batch_no")
    private String batchNo;

    /**
     * 当前客户使用汇率
     */
    @Column(name = "use_rate")
    private BigDecimal useRate;

    /**
     * 当前客户使用手续费
     */
    @Column(name = "service_charge")
    private BigDecimal serviceCharge;

    /**
     * 外币手续费金额
     */
    @Column(name = "charge_amt")
    private BigDecimal chargeAmt;

    /**
     * 买入币种手续费金额
     */
    @Column(name = "charge_amt_buy")
    private BigDecimal chargeAmtBuy;

    @Column(name = "refund_amt")
    private BigDecimal refundAmt;

    /**
     * 请求寻汇锁汇交易返回的交易时间
     */
    @Column(name = "txn_datetime")
    private Date txnDatetime;

    /**
     * 处理状态
     */
    @Column(name = "process_status")
    private ProcessStatusEnum processStatus;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySunrateTradeLockPricePre other = (JsPaySunrateTradeLockPricePre) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getLockPriceId() == null ? other.getLockPriceId() == null : this.getLockPriceId().equals(other.getLockPriceId()))
            && (this.getKycSunrateStoreId() == null ? other.getKycSunrateStoreId() == null : this.getKycSunrateStoreId().equals(other.getKycSunrateStoreId()))
            && (this.getKycSunrateBankId() == null ? other.getKycSunrateBankId() == null : this.getKycSunrateBankId().equals(other.getKycSunrateBankId()))
            && (this.getSubAcctNo() == null ? other.getSubAcctNo() == null : this.getSubAcctNo().equals(other.getSubAcctNo()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getBuyCur() == null ? other.getBuyCur() == null : this.getBuyCur().equals(other.getBuyCur()))
            && (this.getBuyAmt() == null ? other.getBuyAmt() == null : this.getBuyAmt().equals(other.getBuyAmt()))
            && (this.getSellCur() == null ? other.getSellCur() == null : this.getSellCur().equals(other.getSellCur()))
            && (this.getSellAmt() == null ? other.getSellAmt() == null : this.getSellAmt().equals(other.getSellAmt()))
            && (this.getBeneficiaryId() == null ? other.getBeneficiaryId() == null : this.getBeneficiaryId().equals(other.getBeneficiaryId()))
            && (this.getTxnMode() == null ? other.getTxnMode() == null : this.getTxnMode().equals(other.getTxnMode()))
            && (this.getTxnAmt() == null ? other.getTxnAmt() == null : this.getTxnAmt().equals(other.getTxnAmt()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
            && (this.getTradeType() == null ? other.getTradeType() == null : this.getTradeType().equals(other.getTradeType()))
            && (this.getTradeSubType() == null ? other.getTradeSubType() == null : this.getTradeSubType().equals(other.getTradeSubType()))
            && (this.getKycBankId() == null ? other.getKycBankId() == null : this.getKycBankId().equals(other.getKycBankId()))
            && (this.getBankNo() == null ? other.getBankNo() == null : this.getBankNo().equals(other.getBankNo()))
            && (this.getSunrateBankAvailableBalance() == null ? other.getSunrateBankAvailableBalance() == null : this.getSunrateBankAvailableBalance().equals(other.getSunrateBankAvailableBalance()))
            && (this.getSunrateBankCurrentBalance() == null ? other.getSunrateBankCurrentBalance() == null : this.getSunrateBankCurrentBalance().equals(other.getSunrateBankCurrentBalance()))
            && (this.getBatchNo() == null ? other.getBatchNo() == null : this.getBatchNo().equals(other.getBatchNo()))
            && (this.getUseRate() == null ? other.getUseRate() == null : this.getUseRate().equals(other.getUseRate()))
            && (this.getServiceCharge() == null ? other.getServiceCharge() == null : this.getServiceCharge().equals(other.getServiceCharge()))
            && (this.getChargeAmt() == null ? other.getChargeAmt() == null : this.getChargeAmt().equals(other.getChargeAmt()))
            && (this.getChargeAmtBuy() == null ? other.getChargeAmtBuy() == null : this.getChargeAmtBuy().equals(other.getChargeAmtBuy()))
            && (this.getTxnDatetime() == null ? other.getTxnDatetime() == null : this.getTxnDatetime().equals(other.getTxnDatetime()))
            && (this.getProcessStatus() == null ? other.getProcessStatus() == null : this.getProcessStatus().equals(other.getProcessStatus()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getLockPriceId() == null) ? 0 : getLockPriceId().hashCode());
        result = prime * result + ((getKycSunrateStoreId() == null) ? 0 : getKycSunrateStoreId().hashCode());
        result = prime * result + ((getKycSunrateBankId() == null) ? 0 : getKycSunrateBankId().hashCode());
        result = prime * result + ((getSubAcctNo() == null) ? 0 : getSubAcctNo().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getBuyCur() == null) ? 0 : getBuyCur().hashCode());
        result = prime * result + ((getBuyAmt() == null) ? 0 : getBuyAmt().hashCode());
        result = prime * result + ((getSellCur() == null) ? 0 : getSellCur().hashCode());
        result = prime * result + ((getSellAmt() == null) ? 0 : getSellAmt().hashCode());
        result = prime * result + ((getBeneficiaryId() == null) ? 0 : getBeneficiaryId().hashCode());
        result = prime * result + ((getTxnMode() == null) ? 0 : getTxnMode().hashCode());
        result = prime * result + ((getTxnAmt() == null) ? 0 : getTxnAmt().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getTradeType() == null) ? 0 : getTradeType().hashCode());
        result = prime * result + ((getTradeSubType() == null) ? 0 : getTradeSubType().hashCode());
        result = prime * result + ((getKycBankId() == null) ? 0 : getKycBankId().hashCode());
        result = prime * result + ((getBankNo() == null) ? 0 : getBankNo().hashCode());
        result = prime * result + ((getSunrateBankAvailableBalance() == null) ? 0 : getSunrateBankAvailableBalance().hashCode());
        result = prime * result + ((getSunrateBankCurrentBalance() == null) ? 0 : getSunrateBankCurrentBalance().hashCode());
        result = prime * result + ((getBatchNo() == null) ? 0 : getBatchNo().hashCode());
        result = prime * result + ((getUseRate() == null) ? 0 : getUseRate().hashCode());
        result = prime * result + ((getServiceCharge() == null) ? 0 : getServiceCharge().hashCode());
        result = prime * result + ((getChargeAmt() == null) ? 0 : getChargeAmt().hashCode());
        result = prime * result + ((getChargeAmtBuy() == null) ? 0 : getChargeAmtBuy().hashCode());
        result = prime * result + ((getTxnDatetime() == null) ? 0 : getTxnDatetime().hashCode());
        result = prime * result + ((getProcessStatus() == null) ? 0 : getProcessStatus().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}