package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_exchange_router")
public class JsPayExchangeRouter extends IBaseModel implements Serializable {
    /**
     * 路由编号
     */
    @Column(name = "router_no")
    private String routerNo;

    /**
     * 结汇渠道
     */
    @Column(name = "exchange_channel")
    private String exchangeChannel;

    /**
     * 三方支付渠道
     */
    @Column(name = "payment_channel")
    private String paymentChannel;

    /**
     * 是否选中，0未选中，1选中
     */
    @Column(name = "selected_flag")
    private Boolean selectedFlag;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPayExchangeRouter other = (JsPayExchangeRouter) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getRouterNo() == null ? other.getRouterNo() == null : this.getRouterNo().equals(other.getRouterNo()))
            && (this.getExchangeChannel() == null ? other.getExchangeChannel() == null : this.getExchangeChannel().equals(other.getExchangeChannel()))
            && (this.getPaymentChannel() == null ? other.getPaymentChannel() == null : this.getPaymentChannel().equals(other.getPaymentChannel()))
            && (this.getSelectedFlag() == null ? other.getSelectedFlag() == null : this.getSelectedFlag().equals(other.getSelectedFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getRouterNo() == null) ? 0 : getRouterNo().hashCode());
        result = prime * result + ((getExchangeChannel() == null) ? 0 : getExchangeChannel().hashCode());
        result = prime * result + ((getPaymentChannel() == null) ? 0 : getPaymentChannel().hashCode());
        result = prime * result + ((getSelectedFlag() == null) ? 0 : getSelectedFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}