package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "china_pnr_transaction")
public class ChinaPNRTransaction extends IBaseModel implements Serializable {
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 收汇流水号
     */
    @Column(name = "receipt_id")
    private String receiptId;

    /**
     * 明细备案批次号
     */
    @Column(name = "batch_no")
    private String batchNo;

    /**
     * 请求序号
     */
    @Column(name = "ord_num")
    private String ordNum;

    /**
     * 请求时间
     */
    private Date reqtime;

    /**
     * 付款币种
     */
    @Column(name = "pay_cur")
    private String payCur;

    /**
     * 批次总笔数
     */
    @Column(name = "sum_cnt")
    private BigDecimal sumCnt;

    /**
     * 批次总金额
     */
    @Column(name = "sum_amt")
    private BigDecimal sumAmt;

    /**
     * 总笔数
     */
    @Column(name = "pay_tcnt")
    private BigDecimal payTcnt;

    /**
     * 总金额
     */
    @Column(name = "pay_tamt")
    private BigDecimal payTamt;

    /**
     * 扩展字段1
     */
    private String ext1;

    /**
     * 扩展字段2
     */
    private String ext2;

    /**
     * 审核结果通知地址
     */
    @Column(name = "review_url")
    private String reviewUrl;

    /**
     * 结汇结果通知地址
     */
    @Column(name = "result_url")
    private String resultUrl;

    /**
     * 备案状态：0：备案成功，1：备案失败，2：回调结果成功，3：回调结果失败
     */
    private Integer status;

    /**
     * 请求报文
     */
    @Column(name = "request_message")
    private String requestMessage;

    /**
     * 响应报文
     */
    @Column(name = "response_message")
    private String responseMessage;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ChinaPNRTransaction other = (ChinaPNRTransaction) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getReceiptId() == null ? other.getReceiptId() == null : this.getReceiptId().equals(other.getReceiptId()))
            && (this.getBatchNo() == null ? other.getBatchNo() == null : this.getBatchNo().equals(other.getBatchNo()))
            && (this.getOrdNum() == null ? other.getOrdNum() == null : this.getOrdNum().equals(other.getOrdNum()))
            && (this.getReqtime() == null ? other.getReqtime() == null : this.getReqtime().equals(other.getReqtime()))
            && (this.getPayCur() == null ? other.getPayCur() == null : this.getPayCur().equals(other.getPayCur()))
            && (this.getSumCnt() == null ? other.getSumCnt() == null : this.getSumCnt().equals(other.getSumCnt()))
            && (this.getSumAmt() == null ? other.getSumAmt() == null : this.getSumAmt().equals(other.getSumAmt()))
            && (this.getPayTcnt() == null ? other.getPayTcnt() == null : this.getPayTcnt().equals(other.getPayTcnt()))
            && (this.getPayTamt() == null ? other.getPayTamt() == null : this.getPayTamt().equals(other.getPayTamt()))
            && (this.getExt1() == null ? other.getExt1() == null : this.getExt1().equals(other.getExt1()))
            && (this.getExt2() == null ? other.getExt2() == null : this.getExt2().equals(other.getExt2()))
            && (this.getReviewUrl() == null ? other.getReviewUrl() == null : this.getReviewUrl().equals(other.getReviewUrl()))
            && (this.getResultUrl() == null ? other.getResultUrl() == null : this.getResultUrl().equals(other.getResultUrl()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getRequestMessage() == null ? other.getRequestMessage() == null : this.getRequestMessage().equals(other.getRequestMessage()))
            && (this.getResponseMessage() == null ? other.getResponseMessage() == null : this.getResponseMessage().equals(other.getResponseMessage()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getReceiptId() == null) ? 0 : getReceiptId().hashCode());
        result = prime * result + ((getBatchNo() == null) ? 0 : getBatchNo().hashCode());
        result = prime * result + ((getOrdNum() == null) ? 0 : getOrdNum().hashCode());
        result = prime * result + ((getReqtime() == null) ? 0 : getReqtime().hashCode());
        result = prime * result + ((getPayCur() == null) ? 0 : getPayCur().hashCode());
        result = prime * result + ((getSumCnt() == null) ? 0 : getSumCnt().hashCode());
        result = prime * result + ((getSumAmt() == null) ? 0 : getSumAmt().hashCode());
        result = prime * result + ((getPayTcnt() == null) ? 0 : getPayTcnt().hashCode());
        result = prime * result + ((getPayTamt() == null) ? 0 : getPayTamt().hashCode());
        result = prime * result + ((getExt1() == null) ? 0 : getExt1().hashCode());
        result = prime * result + ((getExt2() == null) ? 0 : getExt2().hashCode());
        result = prime * result + ((getReviewUrl() == null) ? 0 : getReviewUrl().hashCode());
        result = prime * result + ((getResultUrl() == null) ? 0 : getResultUrl().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getRequestMessage() == null) ? 0 : getRequestMessage().hashCode());
        result = prime * result + ((getResponseMessage() == null) ? 0 : getResponseMessage().hashCode());
        return result;
    }
}