package com.js.dal.dao.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "china_pnr_trading_flow")
public class ChinaPNRTradingFlow extends IBaseModel implements Serializable {
    /**
     * 交易流水号
     */
    @Column(name = "js_trading_flow_id")
    private String jsTradingFlowId;

    /**
     * 用户Id
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 交易类型  0开户1更新
     */
    @Column(name = "transaction_type")
    private String transactionType;

    /**
     * 交易时间
     */
    @Column(name = "transaction_time")
    private Date transactionTime;

    /**
     * 状态 0开户成功 1开户失败 2审核中
     */
    private String result;

    /**
     * 请求报文
     */
    @Column(name = "request_message")
    private String requestMessage;

    /**
     * 响应报文
     */
    @Column(name = "response_message")
    private String responseMessage;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ChinaPNRTradingFlow other = (ChinaPNRTradingFlow) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getJsTradingFlowId() == null ? other.getJsTradingFlowId() == null : this.getJsTradingFlowId().equals(other.getJsTradingFlowId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getTransactionType() == null ? other.getTransactionType() == null : this.getTransactionType().equals(other.getTransactionType()))
            && (this.getTransactionTime() == null ? other.getTransactionTime() == null : this.getTransactionTime().equals(other.getTransactionTime()))
            && (this.getResult() == null ? other.getResult() == null : this.getResult().equals(other.getResult()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getRequestMessage() == null ? other.getRequestMessage() == null : this.getRequestMessage().equals(other.getRequestMessage()))
            && (this.getResponseMessage() == null ? other.getResponseMessage() == null : this.getResponseMessage().equals(other.getResponseMessage()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getJsTradingFlowId() == null) ? 0 : getJsTradingFlowId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getTransactionType() == null) ? 0 : getTransactionType().hashCode());
        result = prime * result + ((getTransactionTime() == null) ? 0 : getTransactionTime().hashCode());
        result = prime * result + ((getResult() == null) ? 0 : getResult().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getRequestMessage() == null) ? 0 : getRequestMessage().hashCode());
        result = prime * result + ((getResponseMessage() == null) ? 0 : getResponseMessage().hashCode());
        return result;
    }
}