package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.js.common.enums.BankAcctTypeEnum;
import com.js.common.enums.SysPlateformType;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_user_acct")
public class JsPayUserAcct extends IBaseModel implements Serializable {
    /**
     * 平台类型（HFGJ(汇付国际))
     */
    @Column(name = "plateform_type")
    private SysPlateformType plateformType;

    /**
     * 账户类型
     */
    @Column(name = "acct_type")
    private BankAcctTypeEnum acctType;

    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 账户名称
     */
    @Column(name = "acct_name")
    private String acctName;

    /**
     * 账户号
     */
    @Column(name = "acct_no")
    private String acctNo;

    /**
     * 账户余额
     */
    @Column(name = "available_amt")
    private BigDecimal availableAmt;

    /**
     * 冻结金额
     */
    @Column(name = "frozen_amt")
    private BigDecimal frozenAmt;

    /**
     * 昨日余额
     */
    @Column(name = "last_amt")
    private BigDecimal lastAmt;

    /**
     * 账户持有人id
     */
    @Column(name = "store_hold_member")
    private Integer storeHoldMember;

    /**
     * 是否为当前使用[0:不是, 1:是]
     */
    @Column(name = "use_flag")
    private Boolean useFlag;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPayUserAcct other = (JsPayUserAcct) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getPlateformType() == null ? other.getPlateformType() == null : this.getPlateformType().equals(other.getPlateformType()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getAcctName() == null ? other.getAcctName() == null : this.getAcctName().equals(other.getAcctName()))
            && (this.getAcctNo() == null ? other.getAcctNo() == null : this.getAcctNo().equals(other.getAcctNo()))
            && (this.getAvailableAmt() == null ? other.getAvailableAmt() == null : this.getAvailableAmt().equals(other.getAvailableAmt()))
            && (this.getFrozenAmt() == null ? other.getFrozenAmt() == null : this.getFrozenAmt().equals(other.getFrozenAmt()))
            && (this.getLastAmt() == null ? other.getLastAmt() == null : this.getLastAmt().equals(other.getLastAmt()))
            && (this.getStoreHoldMember() == null ? other.getStoreHoldMember() == null : this.getStoreHoldMember().equals(other.getStoreHoldMember()))
            && (this.getUseFlag() == null ? other.getUseFlag() == null : this.getUseFlag().equals(other.getUseFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getPlateformType() == null) ? 0 : getPlateformType().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getAcctName() == null) ? 0 : getAcctName().hashCode());
        result = prime * result + ((getAcctNo() == null) ? 0 : getAcctNo().hashCode());
        result = prime * result + ((getAvailableAmt() == null) ? 0 : getAvailableAmt().hashCode());
        result = prime * result + ((getFrozenAmt() == null) ? 0 : getFrozenAmt().hashCode());
        result = prime * result + ((getLastAmt() == null) ? 0 : getLastAmt().hashCode());
        result = prime * result + ((getStoreHoldMember() == null) ? 0 : getStoreHoldMember().hashCode());
        result = prime * result + ((getUseFlag() == null) ? 0 : getUseFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}