package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_loan_plan_detail")
public class JsLoanPlanDetail extends IBaseModel implements Serializable {
    /**
     * 贷款申请id
     */
    @Column(name = "apply_info_id")
    private String applyInfoId;

    /**
     * 贷款申请编号
     */
    @Column(name = "loan_no")
    private String loanNo;

    /**
     * KYC注册ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 还款期数
     */
    @Column(name = "repay_period")
    private String repayPeriod;

    /**
     * 还款人名称
     */
    private String name;

    /**
     * 还款人手机号
     */
    private String phone;

    /**
     * 未还总额
     */
    @Column(name = "unpay_total")
    private BigDecimal unpayTotal;

    /**
     * 未还本金
     */
    @Column(name = "unpay_principal")
    private BigDecimal unpayPrincipal;

    /**
     * 未还利息
     */
    @Column(name = "unpay_interest")
    private BigDecimal unpayInterest;

    /**
     * 未还服务费
     */
    @Column(name = "unpay_fee")
    private BigDecimal unpayFee;

    /**
     * 未还罚息
     */
    @Column(name = "unpay_penalty")
    private BigDecimal unpayPenalty;

    /**
     * 未还提前还款手续费
     */
    @Column(name = "unpay_prepayment_fee")
    private BigDecimal unpayPrepaymentFee;

    /**
     * 实还总额
     */
    @Column(name = "paid_total")
    private BigDecimal paidTotal;

    /**
     * 已还本金
     */
    @Column(name = "paid_principal")
    private BigDecimal paidPrincipal;

    /**
     * 已还利息
     */
    @Column(name = "paid_interest")
    private BigDecimal paidInterest;

    /**
     * 已还服务费
     */
    @Column(name = "paid_fee")
    private BigDecimal paidFee;

    /**
     * 已还罚息
     */
    @Column(name = "paid_penalty")
    private BigDecimal paidPenalty;

    /**
     * 已还提前还款手续费
     */
    @Column(name = "paid_prepayment_fee")
    private BigDecimal paidPrepaymentFee;

    /**
     * 还款时间
     */
    @Column(name = "repay_time")
    private Date repayTime;

    /**
     * 0初始化1还款中2成功3失败
     */
    @Column(name = "repayment_status")
    private String repaymentStatus;

    /**
     * 渠道支付状态
     * 10初始化11寻汇锁汇成功12寻汇锁汇失败20代发到客户初始化21代发到客户执行中
     * 22代发到客户失败23代发到客户成功30客户账户代发到小贷初始化31客户账户代发到小贷执行中
     * 32客户账户代发到小贷失败33客户账户代发到小贷成功
     */
    @Column(name = "channel_pay_status")
    private String channelPayStatus;

    /**
     * 代发到客户支付批次号
     */
    @Column(name = "customer_batch_no")
    private String customerBatchNo;

    /**
     * 错误原因
     */
    @Column(name = "error_reason")
    private String errorReason;

    /**
     * 客户账户代发到小贷支付批次号
     */
    @Column(name = "loan_batch_no")
    private String loanBatchNo;

    /**
     * 是否还款单已结束  0未结束1正常完结2非正常完结
     */
    @Column(name = "is_end")
    private String isEnd;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsLoanPlanDetail other = (JsLoanPlanDetail) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getApplyInfoId() == null ? other.getApplyInfoId() == null : this.getApplyInfoId().equals(other.getApplyInfoId()))
            && (this.getLoanNo() == null ? other.getLoanNo() == null : this.getLoanNo().equals(other.getLoanNo()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getRepayPeriod() == null ? other.getRepayPeriod() == null : this.getRepayPeriod().equals(other.getRepayPeriod()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getPhone() == null ? other.getPhone() == null : this.getPhone().equals(other.getPhone()))
            && (this.getUnpayTotal() == null ? other.getUnpayTotal() == null : this.getUnpayTotal().equals(other.getUnpayTotal()))
            && (this.getUnpayPrincipal() == null ? other.getUnpayPrincipal() == null : this.getUnpayPrincipal().equals(other.getUnpayPrincipal()))
            && (this.getUnpayInterest() == null ? other.getUnpayInterest() == null : this.getUnpayInterest().equals(other.getUnpayInterest()))
            && (this.getUnpayFee() == null ? other.getUnpayFee() == null : this.getUnpayFee().equals(other.getUnpayFee()))
            && (this.getUnpayPenalty() == null ? other.getUnpayPenalty() == null : this.getUnpayPenalty().equals(other.getUnpayPenalty()))
            && (this.getUnpayPrepaymentFee() == null ? other.getUnpayPrepaymentFee() == null : this.getUnpayPrepaymentFee().equals(other.getUnpayPrepaymentFee()))
            && (this.getPaidTotal() == null ? other.getPaidTotal() == null : this.getPaidTotal().equals(other.getPaidTotal()))
            && (this.getPaidPrincipal() == null ? other.getPaidPrincipal() == null : this.getPaidPrincipal().equals(other.getPaidPrincipal()))
            && (this.getPaidInterest() == null ? other.getPaidInterest() == null : this.getPaidInterest().equals(other.getPaidInterest()))
            && (this.getPaidFee() == null ? other.getPaidFee() == null : this.getPaidFee().equals(other.getPaidFee()))
            && (this.getPaidPenalty() == null ? other.getPaidPenalty() == null : this.getPaidPenalty().equals(other.getPaidPenalty()))
            && (this.getPaidPrepaymentFee() == null ? other.getPaidPrepaymentFee() == null : this.getPaidPrepaymentFee().equals(other.getPaidPrepaymentFee()))
            && (this.getRepayTime() == null ? other.getRepayTime() == null : this.getRepayTime().equals(other.getRepayTime()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getRepaymentStatus() == null ? other.getRepaymentStatus() == null : this.getRepaymentStatus().equals(other.getRepaymentStatus()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getChannelPayStatus() == null ? other.getChannelPayStatus() == null : this.getChannelPayStatus().equals(other.getChannelPayStatus()))
            && (this.getCustomerBatchNo() == null ? other.getCustomerBatchNo() == null : this.getCustomerBatchNo().equals(other.getCustomerBatchNo()))
            && (this.getErrorReason() == null ? other.getErrorReason() == null : this.getErrorReason().equals(other.getErrorReason()))
            && (this.getLoanBatchNo() == null ? other.getLoanBatchNo() == null : this.getLoanBatchNo().equals(other.getLoanBatchNo()))
            && (this.getIsEnd() == null ? other.getIsEnd() == null : this.getIsEnd().equals(other.getIsEnd()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getApplyInfoId() == null) ? 0 : getApplyInfoId().hashCode());
        result = prime * result + ((getLoanNo() == null) ? 0 : getLoanNo().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getRepayPeriod() == null) ? 0 : getRepayPeriod().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getPhone() == null) ? 0 : getPhone().hashCode());
        result = prime * result + ((getUnpayTotal() == null) ? 0 : getUnpayTotal().hashCode());
        result = prime * result + ((getUnpayPrincipal() == null) ? 0 : getUnpayPrincipal().hashCode());
        result = prime * result + ((getUnpayInterest() == null) ? 0 : getUnpayInterest().hashCode());
        result = prime * result + ((getUnpayFee() == null) ? 0 : getUnpayFee().hashCode());
        result = prime * result + ((getUnpayPenalty() == null) ? 0 : getUnpayPenalty().hashCode());
        result = prime * result + ((getUnpayPrepaymentFee() == null) ? 0 : getUnpayPrepaymentFee().hashCode());
        result = prime * result + ((getPaidTotal() == null) ? 0 : getPaidTotal().hashCode());
        result = prime * result + ((getPaidPrincipal() == null) ? 0 : getPaidPrincipal().hashCode());
        result = prime * result + ((getPaidInterest() == null) ? 0 : getPaidInterest().hashCode());
        result = prime * result + ((getPaidFee() == null) ? 0 : getPaidFee().hashCode());
        result = prime * result + ((getPaidPenalty() == null) ? 0 : getPaidPenalty().hashCode());
        result = prime * result + ((getPaidPrepaymentFee() == null) ? 0 : getPaidPrepaymentFee().hashCode());
        result = prime * result + ((getRepayTime() == null) ? 0 : getRepayTime().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getRepaymentStatus() == null) ? 0 : getRepaymentStatus().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getChannelPayStatus() == null) ? 0 : getChannelPayStatus().hashCode());
        result = prime * result + ((getCustomerBatchNo() == null) ? 0 : getCustomerBatchNo().hashCode());
        result = prime * result + ((getErrorReason() == null) ? 0 : getErrorReason().hashCode());
        result = prime * result + ((getLoanBatchNo() == null) ? 0 : getLoanBatchNo().hashCode());
        result = prime * result + ((getIsEnd() == null) ? 0 : getIsEnd().hashCode());
        return result;
    }
}