package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_loan_apply_info")
public class JsLoanApplyInfo extends IBaseModel implements Serializable {
    /**
     * 贷款申请编号
     */
    @Column(name = "loan_no")
    private String loanNo;

    /**
     * KYC注册ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 意向贷款金额
     */
    @Column(name = "apply_amt")
    private BigDecimal applyAmt;

    /**
     * 实际放款金额
     */
    @Column(name = "real_amt")
    private BigDecimal realAmt;

    /**
     * 审核通过金额
     */
    @Column(name = "adopt_amt")
    private BigDecimal adoptAmt;


    /**
     * 申请贷款时间
     */
    @Column(name = "apply_date")
    private Date applyDate;

    /**
     * 申请贷款时间
     */
    @Column(name = "repayment_date")
    private Date repaymentDate;

    /**
     * 贷款状态
     * 审核状态：10等待初审，11初审通过，12初审拒绝，20复审通过，21复审拒绝，22电子签章成功，23电子签章失败 30放款通过，31放款拒绝
     * 核心合同状态：-1合同废止，0未放款，1还款中，2逾期，3案件，4正常结清，5催收减免结清，6正常提前结清，7催收提前结清，8放款中
     */
    @Column(name = "loan_status")
    private String loanStatus;

    /**
     * 还款中状态 0初始化，1自动还款处理中，2主动还款处理中，3逾期还款处理中，4案件还款处理中
     */
    @Column(name = "repayment_status")
    private String repaymentStatus;

    /**
     * 借款天数
     */
    @Column(name = "loan_days")
    private Integer loanDays;

    /**
     * 还款方式
     */
    @Column(name = "repay_type")
    private String repayType;

    /**
     * 产品编号
     */
    @Column(name = "product_no")
    private String productNo;

    /**
     * 产品名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 收款账户名称
     */
    @Column(name = "acct_name")
    private String acctName;

    /**
     * 收款账户号
     */
    @Column(name = "acct_no")
    private String acctNo;

    /**
     * 身份证号
     */
    @Column(name = "cert_no")
    private String certNo;

    /**
     * 银行预留手机号
     */
    @Column(name = "mobile_no")
    private String mobileNo;

    /**
     * 是否贷款单已结束  0未结束1正常完结2非正常完结
     */
    @Column(name = "is_end")
    private String isEnd;

    /**
     * 银行名称
     */
    @Column(name = "bank_name")
    private String bankName;

    /**
     * 银行代码
     */
    @Column(name = "bank_code")
    private String bankCode;

    /**
     * 支行名称
     */
    @Column(name = "bank_branch_name")
    private String bankBranchName;

    /**
     * 支行省
     */
    @Column(name = "bank_branch_privince")
    private String bankBranchPrivince;

    /**
     * 支行市
     */
    @Column(name = "bank_branch_city")
    private String bankBranchCity;
    /**
     * 日利费率
     */
    @Column(name = "interest_rate")
    private String interestRate;
    /**
     *最早还款日期
     */
    @Column(name = "start_date")
    private Date startDate;
    /**
     * 最晚还款日期
     */
    @Column(name = "end_date")
    private Date endDate;
    /**
     * 年利率
     */
    @Column(name = "year_rate")
    private String yearRate;


    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsLoanApplyInfo other = (JsLoanApplyInfo) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getLoanNo() == null ? other.getLoanNo() == null : this.getLoanNo().equals(other.getLoanNo()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getApplyAmt() == null ? other.getApplyAmt() == null : this.getApplyAmt().equals(other.getApplyAmt()))
            && (this.getRealAmt() == null ? other.getRealAmt() == null : this.getRealAmt().equals(other.getRealAmt()))
            && (this.getApplyDate() == null ? other.getApplyDate() == null : this.getApplyDate().equals(other.getApplyDate()))
            && (this.getLoanStatus() == null ? other.getLoanStatus() == null : this.getLoanStatus().equals(other.getLoanStatus()))
            && (this.getLoanDays() == null ? other.getLoanDays() == null : this.getLoanDays().equals(other.getLoanDays()))
            && (this.getRepayType() == null ? other.getRepayType() == null : this.getRepayType().equals(other.getRepayType()))
            && (this.getProductNo() == null ? other.getProductNo() == null : this.getProductNo().equals(other.getProductNo()))
            && (this.getAcctName() == null ? other.getAcctName() == null : this.getAcctName().equals(other.getAcctName()))
            && (this.getAcctNo() == null ? other.getAcctNo() == null : this.getAcctNo().equals(other.getAcctNo()))
            && (this.getCertNo() == null ? other.getCertNo() == null : this.getCertNo().equals(other.getCertNo()))
            && (this.getMobileNo() == null ? other.getMobileNo() == null : this.getMobileNo().equals(other.getMobileNo()))
            && (this.getBankName() == null ? other.getBankName() == null : this.getBankName().equals(other.getBankName()))
            && (this.getBankCode() == null ? other.getBankCode() == null : this.getBankCode().equals(other.getBankCode()))
            && (this.getBankBranchName() == null ? other.getBankBranchName() == null : this.getBankBranchName().equals(other.getBankBranchName()))
            && (this.getBankBranchPrivince() == null ? other.getBankBranchPrivince() == null : this.getBankBranchPrivince().equals(other.getBankBranchPrivince()))
            && (this.getBankBranchCity() == null ? other.getBankBranchCity() == null : this.getBankBranchCity().equals(other.getBankBranchCity()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getLoanNo() == null) ? 0 : getLoanNo().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getApplyAmt() == null) ? 0 : getApplyAmt().hashCode());
        result = prime * result + ((getRealAmt() == null) ? 0 : getRealAmt().hashCode());
        result = prime * result + ((getApplyDate() == null) ? 0 : getApplyDate().hashCode());
        result = prime * result + ((getLoanStatus() == null) ? 0 : getLoanStatus().hashCode());
        result = prime * result + ((getLoanDays() == null) ? 0 : getLoanDays().hashCode());
        result = prime * result + ((getRepayType() == null) ? 0 : getRepayType().hashCode());
        result = prime * result + ((getProductNo() == null) ? 0 : getProductNo().hashCode());
        result = prime * result + ((getAcctName() == null) ? 0 : getAcctName().hashCode());
        result = prime * result + ((getAcctNo() == null) ? 0 : getAcctNo().hashCode());
        result = prime * result + ((getCertNo() == null) ? 0 : getCertNo().hashCode());
        result = prime * result + ((getMobileNo() == null) ? 0 : getMobileNo().hashCode());
        result = prime * result + ((getBankName() == null) ? 0 : getBankName().hashCode());
        result = prime * result + ((getBankCode() == null) ? 0 : getBankCode().hashCode());
        result = prime * result + ((getBankBranchName() == null) ? 0 : getBankBranchName().hashCode());
        result = prime * result + ((getBankBranchPrivince() == null) ? 0 : getBankBranchPrivince().hashCode());
        result = prime * result + ((getBankBranchCity() == null) ? 0 : getBankBranchCity().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}