package com.js.dal.dao.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import com.js.common.enums.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "generate_file_record")
public class GenerateFileRecord extends IBaseModel implements Serializable {
    /**
     * 注册表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 生成文件编号
     */
    @Column(name = "generate_no")
    private String generateNo;

    /**
     * 生成类型（GENERATE_TRADE_RECORD-下载交易记录，GENERATE_TRADE_RECEIPT-下载回执单，GENERATE_FUND_RECORD-下载资金记录）
     */
    @Column(name = "generate_type")
    private GenerateFileType generateType;

    /**
     * 生成起始日期
     */
    @Column(name = "generate_start_date")
    private Date generateStartDate;

    /**
     * 生成结束日期
     */
    @Column(name = "generate_end_date")
    private Date generateEndDate;

    /**
     * js文件资源表主键ID
     */
    @Column(name = "comm_file_id")
    private String commFileId;

    /**
     * '存放路径'
     */
    @Column(name = "file_save_path")
    private String fileSavePath;

    /**
     * '显示名称'
     */
    @Column(name = "file_show_name")
    private String fileShowName;

    /**
     * '下载文件类型'
     */
    @Column(name = "file_type")
    private FileType fileType;

    /**
     * '平台'
     */
    @Column(name = "store_plateform_code")
    private String storePlateformCode;

    /**
     * ''店铺ID''
     */
    @Column(name = "kyc_store_id")
    private String kycStoreId;
    @Column(name = "store_name")
    private String storeName;

    /**
     * '语言类型'
     */
    @Column(name = "language_type")
    private LanguageType languageType;

    /**
     * 入账处理状态(TRADE_UNPROCESSED-生成中，TRADE_PROCESSED-生成完成)
     */
    @Column(name = "process_status")
    private ProcessStatusEnum processStatus;

    /**
     * '''交易类型'''
     */
    @Column(name = "trade_type")
    private String tradeType;

    /**
     * '账号'
     */
    @Column(name = "`acct_no`")
    private String acctNo;

    /**
     * '平台名称'
     */
    @Column(name = "`store_plateform_name`")
    private String storePlateformName;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        GenerateFileRecord other = (GenerateFileRecord) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getGenerateType() == null ? other.getGenerateType() == null : this.getGenerateType().equals(other.getGenerateType()))
            && (this.getGenerateStartDate() == null ? other.getGenerateStartDate() == null : this.getGenerateStartDate().equals(other.getGenerateStartDate()))
            && (this.getGenerateEndDate() == null ? other.getGenerateEndDate() == null : this.getGenerateEndDate().equals(other.getGenerateEndDate()))
            && (this.getCommFileId() == null ? other.getCommFileId() == null : this.getCommFileId().equals(other.getCommFileId()))
            && (this.getProcessStatus() == null ? other.getProcessStatus() == null : this.getProcessStatus().equals(other.getProcessStatus()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getGenerateType() == null) ? 0 : getGenerateType().hashCode());
        result = prime * result + ((getGenerateStartDate() == null) ? 0 : getGenerateStartDate().hashCode());
        result = prime * result + ((getGenerateEndDate() == null) ? 0 : getGenerateEndDate().hashCode());
        result = prime * result + ((getCommFileId() == null) ? 0 : getCommFileId().hashCode());
        result = prime * result + ((getProcessStatus() == null) ? 0 : getProcessStatus().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}