package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "fadada_certi_personal")
public class FadadaCertiPersonal extends IBaseModel implements Serializable {
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 客户 id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 存证名称
     */
    @Column(name = "preservation_name")
    private String preservationName;

    /**
     * 存证数据提供方
     */
    @Column(name = "preservation_data_provider")
    private String preservationDataProvider;

    /**
     * 姓名
     */
    private String name;

    /**
     * 证件类型
     */
    @Column(name = "document_type")
    private String documentType;

    /**
     * 证件号
     */
    private String idcard;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 实名时间
     */
    @Column(name = "verified_time")
    private String verifiedTime;

    /**
     * 实名存证类型
     */
    @Column(name = "verified_type")
    private String verifiedType;

    /**
     * 银行名称
     */
    @Column(name = "bank_name")
    private String bankName;

    /**
     * 银行卡号
     */
    @Column(name = "bank_no")
    private String bankNo;

    /**
     * 是否认证成功后自动申请实名证书
     */
    @Column(name = "cert_flag")
    private Boolean certFlag;

    /**
     * 存证编号，存证成功后由法大大返回
     */
    @Column(name = "evidence_no")
    private String evidenceNo;

    /**
     * 是否成功申请了证书
     */
    @Column(name = "apply_ca")
    private Boolean applyCa;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        FadadaCertiPersonal other = (FadadaCertiPersonal) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getCustomerId() == null ? other.getCustomerId() == null : this.getCustomerId().equals(other.getCustomerId()))
            && (this.getPreservationName() == null ? other.getPreservationName() == null : this.getPreservationName().equals(other.getPreservationName()))
            && (this.getPreservationDataProvider() == null ? other.getPreservationDataProvider() == null : this.getPreservationDataProvider().equals(other.getPreservationDataProvider()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getDocumentType() == null ? other.getDocumentType() == null : this.getDocumentType().equals(other.getDocumentType()))
            && (this.getIdcard() == null ? other.getIdcard() == null : this.getIdcard().equals(other.getIdcard()))
            && (this.getMobile() == null ? other.getMobile() == null : this.getMobile().equals(other.getMobile()))
            && (this.getVerifiedTime() == null ? other.getVerifiedTime() == null : this.getVerifiedTime().equals(other.getVerifiedTime()))
            && (this.getVerifiedType() == null ? other.getVerifiedType() == null : this.getVerifiedType().equals(other.getVerifiedType()))
            && (this.getBankName() == null ? other.getBankName() == null : this.getBankName().equals(other.getBankName()))
            && (this.getBankNo() == null ? other.getBankNo() == null : this.getBankNo().equals(other.getBankNo()))
            && (this.getCertFlag() == null ? other.getCertFlag() == null : this.getCertFlag().equals(other.getCertFlag()))
            && (this.getEvidenceNo() == null ? other.getEvidenceNo() == null : this.getEvidenceNo().equals(other.getEvidenceNo()))
            && (this.getApplyCa() == null ? other.getApplyCa() == null : this.getApplyCa().equals(other.getApplyCa()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getCustomerId() == null) ? 0 : getCustomerId().hashCode());
        result = prime * result + ((getPreservationName() == null) ? 0 : getPreservationName().hashCode());
        result = prime * result + ((getPreservationDataProvider() == null) ? 0 : getPreservationDataProvider().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getDocumentType() == null) ? 0 : getDocumentType().hashCode());
        result = prime * result + ((getIdcard() == null) ? 0 : getIdcard().hashCode());
        result = prime * result + ((getMobile() == null) ? 0 : getMobile().hashCode());
        result = prime * result + ((getVerifiedTime() == null) ? 0 : getVerifiedTime().hashCode());
        result = prime * result + ((getVerifiedType() == null) ? 0 : getVerifiedType().hashCode());
        result = prime * result + ((getBankName() == null) ? 0 : getBankName().hashCode());
        result = prime * result + ((getBankNo() == null) ? 0 : getBankNo().hashCode());
        result = prime * result + ((getCertFlag() == null) ? 0 : getCertFlag().hashCode());
        result = prime * result + ((getEvidenceNo() == null) ? 0 : getEvidenceNo().hashCode());
        result = prime * result + ((getApplyCa() == null) ? 0 : getApplyCa().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}