package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "kyc_sunrate_register")
public class KycSunrateRegister extends IBaseModel implements Serializable {
    /**
     * 注册表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 实名表主键ID
     */
    @Column(name = "kyc_certi_id")
    private String kycCertiId;

    /**
     * 实名类型（1-中国大陆-个人，2-中国大陆-企业，3-中国香港-个人，4-中国香港-企业）
     */
    @Column(name = "kyc_certi_type")
    private Integer kycCertiType;

    /**
     * 寻汇返回注册编号key
     */
    @Column(name = "register_id")
    private String registerId;

    /**
     * 注册人姓名
     */
    @Column(name = "register_name")
    private String registerName;

    /**
     * 注册邮箱
     */
    @Column(name = "register_email")
    private String registerEmail;

    /**
     * 注册手机号
     */
    @Column(name = "register_mobile")
    private String registerMobile;

    /**
     * 注册类型（1-个人，2-公司）
     */
    @Column(name = "register_type")
    private Integer registerType;

    /**
     * 注册状态(0:提交未未审核, 1:审核通过，2:审核未通过（驳回，拒绝))
     */
    @Column(name = "register_status")
    private Integer registerStatus;

    /**
     * 备注-审核结果说明
     */
    private String remark;

    /**
     * 名称（个人：姓名，企业：公司名称）
     */
    private String name;

    /**
     * 组织机构代码（识别客户，本接口文档其他地方出现不再说明，个人：请求方客户 ID 或身份号码，企业：组织结构代码）
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 身份类型（1-法定代表人，2-授权代表人）
     */
    @Column(name = "identity_type")
    private Integer identityType;

    /**
     * 经营地址
     */
    @Column(name = "open_address")
    private String openAddress;

    /**
     * 目录路径(资质文件，组织机构号/文件类型，/INPUT/91510100MA6C72JG4D/KYC/ )
     */
    @Column(name = "dir_path")
    private String dirPath;

    /**
     * 文件列表（Array）
     */
    @Column(name = "file_id_list")
    private String fileIdList;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        KycSunrateRegister other = (KycSunrateRegister) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKycCertiId() == null ? other.getKycCertiId() == null : this.getKycCertiId().equals(other.getKycCertiId()))
            && (this.getKycCertiType() == null ? other.getKycCertiType() == null : this.getKycCertiType().equals(other.getKycCertiType()))
            && (this.getRegisterId() == null ? other.getRegisterId() == null : this.getRegisterId().equals(other.getRegisterId()))
            && (this.getRegisterName() == null ? other.getRegisterName() == null : this.getRegisterName().equals(other.getRegisterName()))
            && (this.getRegisterEmail() == null ? other.getRegisterEmail() == null : this.getRegisterEmail().equals(other.getRegisterEmail()))
            && (this.getRegisterMobile() == null ? other.getRegisterMobile() == null : this.getRegisterMobile().equals(other.getRegisterMobile()))
            && (this.getRegisterType() == null ? other.getRegisterType() == null : this.getRegisterType().equals(other.getRegisterType()))
            && (this.getRegisterStatus() == null ? other.getRegisterStatus() == null : this.getRegisterStatus().equals(other.getRegisterStatus()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getIdentityType() == null ? other.getIdentityType() == null : this.getIdentityType().equals(other.getIdentityType()))
            && (this.getOpenAddress() == null ? other.getOpenAddress() == null : this.getOpenAddress().equals(other.getOpenAddress()))
            && (this.getDirPath() == null ? other.getDirPath() == null : this.getDirPath().equals(other.getDirPath()))
            && (this.getFileIdList() == null ? other.getFileIdList() == null : this.getFileIdList().equals(other.getFileIdList()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKycCertiId() == null) ? 0 : getKycCertiId().hashCode());
        result = prime * result + ((getKycCertiType() == null) ? 0 : getKycCertiType().hashCode());
        result = prime * result + ((getRegisterId() == null) ? 0 : getRegisterId().hashCode());
        result = prime * result + ((getRegisterName() == null) ? 0 : getRegisterName().hashCode());
        result = prime * result + ((getRegisterEmail() == null) ? 0 : getRegisterEmail().hashCode());
        result = prime * result + ((getRegisterMobile() == null) ? 0 : getRegisterMobile().hashCode());
        result = prime * result + ((getRegisterType() == null) ? 0 : getRegisterType().hashCode());
        result = prime * result + ((getRegisterStatus() == null) ? 0 : getRegisterStatus().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getIdentityType() == null) ? 0 : getIdentityType().hashCode());
        result = prime * result + ((getOpenAddress() == null) ? 0 : getOpenAddress().hashCode());
        result = prime * result + ((getDirPath() == null) ? 0 : getDirPath().hashCode());
        result = prime * result + ((getFileIdList() == null) ? 0 : getFileIdList().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}