package com.js.dal.dao.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import com.js.common.enums.CertiFileType;
import com.js.common.enums.ProcessStatusEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "kyc_certi_contacts")
public class KycCertiContacts extends IBaseModel implements Serializable {
    /**
     * 注册表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 实名表主键ID
     */
    @Column(name = "kyc_certi_id")
    private String kycCertiId;

    /**
     * 联系人类型
     */
    @Column(name = "contact_type")
    private String contactType;

    /**
     * 联系人名称
     */
    @Column(name = "contact_name")
    private String contactName;

    /**
     * 联系人证件类型
     */
    @Column(name = "id_type")
    private CertiFileType idType;

    /**
     * 联系人证件类型名称
     */
    @Column(name = "id_type_name")
    private String idTypeName;

    /**
     * 联系人证件号
     */
    @Column(name = "id_no")
    private String idNo;

    /**
     * 联系人常用住址
     */
    private String address;

    /**
     * 身份证有效起始日期
     */
    @Column(name = "effective_start_time")
    private Date effectiveStartTime;

    /**
     * 身份证有效截止日期
     */
    @Column(name = "effective_end_time")
    private Date effectiveEndTime;

    /**
     * 是否长期有效(0:非长期，1：长期)
     */
    @Column(name = "long_flag")
    private Boolean longFlag;

    /**
     * 联系人手机号
     */
    @Column(name = "phone_no")
    private String phoneNo;

    /**
     * 联系人邮箱
     */
    private String email;

    /**
     * 联系人状态
     */
    private ProcessStatusEnum status;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        KycCertiContacts other = (KycCertiContacts) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKycCertiId() == null ? other.getKycCertiId() == null : this.getKycCertiId().equals(other.getKycCertiId()))
            && (this.getContactType() == null ? other.getContactType() == null : this.getContactType().equals(other.getContactType()))
            && (this.getContactName() == null ? other.getContactName() == null : this.getContactName().equals(other.getContactName()))
            && (this.getIdType() == null ? other.getIdType() == null : this.getIdType().equals(other.getIdType()))
            && (this.getIdTypeName() == null ? other.getIdTypeName() == null : this.getIdTypeName().equals(other.getIdTypeName()))
            && (this.getIdNo() == null ? other.getIdNo() == null : this.getIdNo().equals(other.getIdNo()))
            && (this.getAddress() == null ? other.getAddress() == null : this.getAddress().equals(other.getAddress()))
            && (this.getEffectiveStartTime() == null ? other.getEffectiveStartTime() == null : this.getEffectiveStartTime().equals(other.getEffectiveStartTime()))
            && (this.getEffectiveEndTime() == null ? other.getEffectiveEndTime() == null : this.getEffectiveEndTime().equals(other.getEffectiveEndTime()))
            && (this.getLongFlag() == null ? other.getLongFlag() == null : this.getLongFlag().equals(other.getLongFlag()))
            && (this.getPhoneNo() == null ? other.getPhoneNo() == null : this.getPhoneNo().equals(other.getPhoneNo()))
            && (this.getEmail() == null ? other.getEmail() == null : this.getEmail().equals(other.getEmail()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKycCertiId() == null) ? 0 : getKycCertiId().hashCode());
        result = prime * result + ((getContactType() == null) ? 0 : getContactType().hashCode());
        result = prime * result + ((getContactName() == null) ? 0 : getContactName().hashCode());
        result = prime * result + ((getIdType() == null) ? 0 : getIdType().hashCode());
        result = prime * result + ((getIdTypeName() == null) ? 0 : getIdTypeName().hashCode());
        result = prime * result + ((getIdNo() == null) ? 0 : getIdNo().hashCode());
        result = prime * result + ((getAddress() == null) ? 0 : getAddress().hashCode());
        result = prime * result + ((getEffectiveStartTime() == null) ? 0 : getEffectiveStartTime().hashCode());
        result = prime * result + ((getEffectiveEndTime() == null) ? 0 : getEffectiveEndTime().hashCode());
        result = prime * result + ((getLongFlag() == null) ? 0 : getLongFlag().hashCode());
        result = prime * result + ((getPhoneNo() == null) ? 0 : getPhoneNo().hashCode());
        result = prime * result + ((getEmail() == null) ? 0 : getEmail().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        return result;
    }
}