package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_sync_amazon_shipment_event_item")
public class JsSyncAmazonShipmentEventItem extends IBaseModel implements Serializable {
    /**
     * 用户 id
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 绑定的店铺 id
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 卖家 sku
     */
    private String sellersku;

    /**
     * 商品订单id
     */
    @Column(name = "order_id")
    private String orderId;

    /**
     * 商品明细 id
     */
    @Column(name = "order_item_id")
    private String orderItemId;

    /**
     * 商品明细调整 id
     */
    @Column(name = "order_adjustment_item_id")
    private String orderAdjustmentItemId;

    /**
     * 商品数量
     */
    @Column(name = "quantity_shipped")
    private BigDecimal quantityShipped;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsSyncAmazonShipmentEventItem other = (JsSyncAmazonShipmentEventItem) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getSellersku() == null ? other.getSellersku() == null : this.getSellersku().equals(other.getSellersku()))
            && (this.getOrderId() == null ? other.getOrderId() == null : this.getOrderId().equals(other.getOrderId()))
            && (this.getOrderItemId() == null ? other.getOrderItemId() == null : this.getOrderItemId().equals(other.getOrderItemId()))
            && (this.getOrderAdjustmentItemId() == null ? other.getOrderAdjustmentItemId() == null : this.getOrderAdjustmentItemId().equals(other.getOrderAdjustmentItemId()))
            && (this.getQuantityShipped() == null ? other.getQuantityShipped() == null : this.getQuantityShipped().equals(other.getQuantityShipped()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getSellersku() == null) ? 0 : getSellersku().hashCode());
        result = prime * result + ((getOrderId() == null) ? 0 : getOrderId().hashCode());
        result = prime * result + ((getOrderItemId() == null) ? 0 : getOrderItemId().hashCode());
        result = prime * result + ((getOrderAdjustmentItemId() == null) ? 0 : getOrderAdjustmentItemId().hashCode());
        result = prime * result + ((getQuantityShipped() == null) ? 0 : getQuantityShipped().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}