package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_sync_amazon_financial_event_group")
public class JsSyncAmazonFinancialEventGroup extends IBaseModel implements Serializable {
    /**
     * 用户 id
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 绑定的店铺 id
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 账单 id
     */
    @Column(name = "financial_event_group_id")
    private String financialEventGroupId;

    /**
     * 结算是否已经完成
     */
    @Column(name = "processing_status")
    private String processingStatus;

    /**
     * 资金状态
     */
    @Column(name = "fund_transfer_status")
    private String fundTransferStatus;

    /**
     * 源交易总金额货币类型
     */
    @Column(name = "original_total_code")
    private String originalTotalCode;

    /**
     * 源交易总金额
     */
    @Column(name = "original_total")
    private BigDecimal originalTotal;

    /**
     * 交易总金额货币类型
     */
    @Column(name = "converted_total_code")
    private String convertedTotalCode;

    /**
     * 交易总金额
     */
    @Column(name = "converted_total")
    private BigDecimal convertedTotal;

    /**
     * 市场名称
     */
    @Column(name = "marketplace_name")
    private String marketplaceName;

    /**
     * 交易日期，只在完成时有值
     */
    @Column(name = "fund_transfer_date")
    private Date fundTransferDate;

    /**
     * 卖家查找交易跟踪 id
     */
    @Column(name = "trace_id")
    private String traceId;

    /**
     * 账号尾号
     */
    @Column(name = "account_tail")
    private String accountTail;

    /**
     * 结算开始时余额类型
     */
    @Column(name = "beginning_balance_code")
    private String beginningBalanceCode;

    /**
     * 结算开始时余额
     */
    @Column(name = "beginning_balance")
    private BigDecimal beginningBalance;

    /**
     * 交易开始时间
     */
    @Column(name = "financial_event_group_start")
    private Date financialEventGroupStart;

    /**
     * 交易结束时间
     */
    @Column(name = "financial_event_group_end")
    private Date financialEventGroupEnd;

    /**
     * 同步时间
     */
    @Column(name = "sync_date")
    private Date syncDate;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsSyncAmazonFinancialEventGroup other = (JsSyncAmazonFinancialEventGroup) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getFinancialEventGroupId() == null ? other.getFinancialEventGroupId() == null : this.getFinancialEventGroupId().equals(other.getFinancialEventGroupId()))
            && (this.getProcessingStatus() == null ? other.getProcessingStatus() == null : this.getProcessingStatus().equals(other.getProcessingStatus()))
            && (this.getFundTransferStatus() == null ? other.getFundTransferStatus() == null : this.getFundTransferStatus().equals(other.getFundTransferStatus()))
            && (this.getOriginalTotalCode() == null ? other.getOriginalTotalCode() == null : this.getOriginalTotalCode().equals(other.getOriginalTotalCode()))
            && (this.getOriginalTotal() == null ? other.getOriginalTotal() == null : this.getOriginalTotal().equals(other.getOriginalTotal()))
            && (this.getConvertedTotalCode() == null ? other.getConvertedTotalCode() == null : this.getConvertedTotalCode().equals(other.getConvertedTotalCode()))
            && (this.getConvertedTotal() == null ? other.getConvertedTotal() == null : this.getConvertedTotal().equals(other.getConvertedTotal()))
            && (this.getMarketplaceName() == null ? other.getMarketplaceName() == null : this.getMarketplaceName().equals(other.getMarketplaceName()))
            && (this.getFundTransferDate() == null ? other.getFundTransferDate() == null : this.getFundTransferDate().equals(other.getFundTransferDate()))
            && (this.getTraceId() == null ? other.getTraceId() == null : this.getTraceId().equals(other.getTraceId()))
            && (this.getAccountTail() == null ? other.getAccountTail() == null : this.getAccountTail().equals(other.getAccountTail()))
            && (this.getBeginningBalanceCode() == null ? other.getBeginningBalanceCode() == null : this.getBeginningBalanceCode().equals(other.getBeginningBalanceCode()))
            && (this.getBeginningBalance() == null ? other.getBeginningBalance() == null : this.getBeginningBalance().equals(other.getBeginningBalance()))
            && (this.getFinancialEventGroupStart() == null ? other.getFinancialEventGroupStart() == null : this.getFinancialEventGroupStart().equals(other.getFinancialEventGroupStart()))
            && (this.getFinancialEventGroupEnd() == null ? other.getFinancialEventGroupEnd() == null : this.getFinancialEventGroupEnd().equals(other.getFinancialEventGroupEnd()))
            && (this.getSyncDate() == null ? other.getSyncDate() == null : this.getSyncDate().equals(other.getSyncDate()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getFinancialEventGroupId() == null) ? 0 : getFinancialEventGroupId().hashCode());
        result = prime * result + ((getProcessingStatus() == null) ? 0 : getProcessingStatus().hashCode());
        result = prime * result + ((getFundTransferStatus() == null) ? 0 : getFundTransferStatus().hashCode());
        result = prime * result + ((getOriginalTotalCode() == null) ? 0 : getOriginalTotalCode().hashCode());
        result = prime * result + ((getOriginalTotal() == null) ? 0 : getOriginalTotal().hashCode());
        result = prime * result + ((getConvertedTotalCode() == null) ? 0 : getConvertedTotalCode().hashCode());
        result = prime * result + ((getConvertedTotal() == null) ? 0 : getConvertedTotal().hashCode());
        result = prime * result + ((getMarketplaceName() == null) ? 0 : getMarketplaceName().hashCode());
        result = prime * result + ((getFundTransferDate() == null) ? 0 : getFundTransferDate().hashCode());
        result = prime * result + ((getTraceId() == null) ? 0 : getTraceId().hashCode());
        result = prime * result + ((getAccountTail() == null) ? 0 : getAccountTail().hashCode());
        result = prime * result + ((getBeginningBalanceCode() == null) ? 0 : getBeginningBalanceCode().hashCode());
        result = prime * result + ((getBeginningBalance() == null) ? 0 : getBeginningBalance().hashCode());
        result = prime * result + ((getFinancialEventGroupStart() == null) ? 0 : getFinancialEventGroupStart().hashCode());
        result = prime * result + ((getFinancialEventGroupEnd() == null) ? 0 : getFinancialEventGroupEnd().hashCode());
        result = prime * result + ((getSyncDate() == null) ? 0 : getSyncDate().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}