package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_trade")
public class JsPayTrade extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    @Column(name = "kyc_sunrate_store_id")
    private String kycSunrateStoreId;

    /**
     * 入账账户号
     */
    @Column(name = "in_acct")
    private String inAcct;

    /**
     * 入账账户名称
     */
    @Column(name = "in_acct_name")
    private String inAcctName;

    /**
     * 出账账户号
     */
    @Column(name = "out_acct")
    private String outAcct;

    /**
     * 出账账户名称
     */
    @Column(name = "out_acct_name")
    private String outAcctName;

    /**
     * '汇付代发明细流水号'
     */
    @Column(name = "`substitute_detail_id`")
    private String substituteDetailId;

    /**
     * 外部交易单号
     */
    @Column(name = "trade_no")
    private String tradeNo;

    /**
     * 锁汇流水号
     */
    @Column(name = "lock_no")
    private String lockNo;

    /**
     * 锁汇交易编号
     */
    @Column(name = "txn_no")
    private String txnNo;

    /**
     * 寻汇收款虚拟子账户ID
     */
    @Column(name = "kyc_sunrate_bank_id")
    private String kycSunrateBankId;

    /**
     * 交易类型[0:账户入账,1:账户出账]
     */
    @Column(name = "trade_type")
    private TradeTypeEnum tradeType;

    /**
     * 交易子类型[0:子账户入账,1:还款,2:提现,3:提现手续费,4:逾期费]
     */
    @Column(name = "trade_sub_type")
    private TradeSubTypeEnum tradeSubType;

    /**
     * 操作币种
     */
    @Column(name = "cur_id")
    private String curId;

    /**
     * 处理状态
     */
    @Column(name = "process_status")
    private ProcessStatusEnum processStatus;

    /**
     * 交易金额
     */
    @Column(name = "trade_amt")
    private BigDecimal tradeAmt;

    /**
     * 出账金额
     */
    @Column(name = "out_amt")
    private BigDecimal outAmt;

    /**
     * 入账金额
     */
    @Column(name = "in_amt")
    private BigDecimal inAmt;

    /**
     * 账户剩余金额
     */
    @Column(name = "user_acct_curr_amt")
    private BigDecimal userAcctCurrAmt;

    /**
     * 交易后账户总借款
     */
    @Column(name = "user_acct_borrow_amt")
    private BigDecimal userAcctBorrowAmt;

    /**
     * 入账账户可用余额
     */
    @Column(name = "in_acct_available_amt")
    private BigDecimal inAcctAvailableAmt;

    /**
     * 出账账户可用余额
     */
    @Column(name = "out_acct_available_amt")
    private BigDecimal outAcctAvailableAmt;

    /**
     * 交易时间
     */
    @Column(name = "trade_dts")
    private Date tradeDts;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPayTrade other = (JsPayTrade) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKycSunrateStoreId() == null ? other.getKycSunrateStoreId() == null : this.getKycSunrateStoreId().equals(other.getKycSunrateStoreId()))
            && (this.getInAcct() == null ? other.getInAcct() == null : this.getInAcct().equals(other.getInAcct()))
            && (this.getInAcctName() == null ? other.getInAcctName() == null : this.getInAcctName().equals(other.getInAcctName()))
            && (this.getOutAcct() == null ? other.getOutAcct() == null : this.getOutAcct().equals(other.getOutAcct()))
            && (this.getOutAcctName() == null ? other.getOutAcctName() == null : this.getOutAcctName().equals(other.getOutAcctName()))
            && (this.getTradeNo() == null ? other.getTradeNo() == null : this.getTradeNo().equals(other.getTradeNo()))
            && (this.getKycSunrateBankId() == null ? other.getKycSunrateBankId() == null : this.getKycSunrateBankId().equals(other.getKycSunrateBankId()))
            && (this.getTradeType() == null ? other.getTradeType() == null : this.getTradeType().equals(other.getTradeType()))
            && (this.getTradeSubType() == null ? other.getTradeSubType() == null : this.getTradeSubType().equals(other.getTradeSubType()))
            && (this.getCurId() == null ? other.getCurId() == null : this.getCurId().equals(other.getCurId()))
            && (this.getTradeAmt() == null ? other.getTradeAmt() == null : this.getTradeAmt().equals(other.getTradeAmt()))
            && (this.getOutAmt() == null ? other.getOutAmt() == null : this.getOutAmt().equals(other.getOutAmt()))
            && (this.getInAmt() == null ? other.getInAmt() == null : this.getInAmt().equals(other.getInAmt()))
            && (this.getUserAcctCurrAmt() == null ? other.getUserAcctCurrAmt() == null : this.getUserAcctCurrAmt().equals(other.getUserAcctCurrAmt()))
            && (this.getUserAcctBorrowAmt() == null ? other.getUserAcctBorrowAmt() == null : this.getUserAcctBorrowAmt().equals(other.getUserAcctBorrowAmt()))
            && (this.getInAcctAvailableAmt() == null ? other.getInAcctAvailableAmt() == null : this.getInAcctAvailableAmt().equals(other.getInAcctAvailableAmt()))
            && (this.getOutAcctAvailableAmt() == null ? other.getOutAcctAvailableAmt() == null : this.getOutAcctAvailableAmt().equals(other.getOutAcctAvailableAmt()))
            && (this.getTradeDts() == null ? other.getTradeDts() == null : this.getTradeDts().equals(other.getTradeDts()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKycSunrateStoreId() == null) ? 0 : getKycSunrateStoreId().hashCode());
        result = prime * result + ((getInAcct() == null) ? 0 : getInAcct().hashCode());
        result = prime * result + ((getInAcctName() == null) ? 0 : getInAcctName().hashCode());
        result = prime * result + ((getOutAcct() == null) ? 0 : getOutAcct().hashCode());
        result = prime * result + ((getOutAcctName() == null) ? 0 : getOutAcctName().hashCode());
        result = prime * result + ((getTradeNo() == null) ? 0 : getTradeNo().hashCode());
        result = prime * result + ((getKycSunrateBankId() == null) ? 0 : getKycSunrateBankId().hashCode());
        result = prime * result + ((getTradeType() == null) ? 0 : getTradeType().hashCode());
        result = prime * result + ((getTradeSubType() == null) ? 0 : getTradeSubType().hashCode());
        result = prime * result + ((getCurId() == null) ? 0 : getCurId().hashCode());
        result = prime * result + ((getTradeAmt() == null) ? 0 : getTradeAmt().hashCode());
        result = prime * result + ((getOutAmt() == null) ? 0 : getOutAmt().hashCode());
        result = prime * result + ((getInAmt() == null) ? 0 : getInAmt().hashCode());
        result = prime * result + ((getUserAcctCurrAmt() == null) ? 0 : getUserAcctCurrAmt().hashCode());
        result = prime * result + ((getUserAcctBorrowAmt() == null) ? 0 : getUserAcctBorrowAmt().hashCode());
        result = prime * result + ((getInAcctAvailableAmt() == null) ? 0 : getInAcctAvailableAmt().hashCode());
        result = prime * result + ((getOutAcctAvailableAmt() == null) ? 0 : getOutAcctAvailableAmt().hashCode());
        result = prime * result + ((getTradeDts() == null) ? 0 : getTradeDts().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}