package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_supplier_bat_dtl")
public class JsPaySupplierBatDtl extends IBaseModel implements Serializable {

    /**
     * 批次号
     */
    @Column(name = "batch_id")
    private String batchId;
    /**
     * 顺序号
     */
    @Column(name = "seq_no")
    private String seqNo;

    /**
     * 商户流水号
     */
    @Column(name = "business_no")
    private String businessNo;

    /**
     * 供货商ID
     */
    @Column(name = "supplier_id")
    private String supplierId;

    /**
     * 店铺ID
     */
    @Column(name = "store_id")
    private String storeId;
    /**
     * 店铺编号
     */
    @Column(name = "sub_acct_no")
    private String subAcctNo;
    /**
     * 店铺名称
     */
    @Column(name = "store_name")
    private String storeName;

    /**
     * 受益人编号
     */
    @Column(name = "beneficiary_id")
    private String beneficiaryId;


    /**
     * 电商平台 01 amazon ，02 ebay ，03 yahoo，04 fril  ，05 mercari
     */
    @Column(name = "store_plateform")
    private String storePlateform;

    /**
     * 收款方联系电话
     */
    @Column(name = "rcv_phone")
    private String rcvPhone;

    /**
     * 交易日期
     */
    @Column(name = "trade_date")
    private Date tradeDate;

    /**
     * 交易币种
     */
    @Column(name = "trade_cur")
    private String tradeCur;

    /**
     * 交易金额
     */
    @Column(name = "trade_amt")
    private BigDecimal tradeAmt;

    /**
     * 商品名称
     */
    @Column(name = "goods_name")
    private String goodsName;

    /**
     * 数量
     */
    private Integer amount;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 物流方式
     */
    @Column(name = "logistics_way")
    private String logisticsWay;

    /**
     * 采购方式
     */
    @Column(name = "purchase_way")
    private String purchaseWay;

    /**
     * 贸易类型
     */
    @Column(name = "trade_type")
    private String tradeType;

    /**
     * 付款状态[ A0 审核中 A2 审核通过 A3 审核失败 B1 入账失败 B2 入账成功 S1 出账失败 S2 出账成功 ]
     */
    private String status;

    /**
     * 失败原因
     */
    @Column(name = "fail_reason")
    private String failReason;

    /**
     * 错误码
     */
    @Column(name = "fail_code")
    private String failCode;

    /**
     * 锁汇流水号
     */
    @Column(name = "lock_no")
    private String lockNo;

    /**
     * 缴税寻汇流水号
     */
    @Column(name = "txn_no")
    private String txnNo;

    /**
     * 出账金额
     */
    @Column(name = "pay_amt")
    private BigDecimal payAmt;

    /**
     * 出账币种
     */
    @Column(name = "pay_cur")
    private String payCur;

    /**
     * 手续费金额
     */
    @Column(name = "fee_amt")
    private BigDecimal feeAmt;

    /**
     * 手续费币种
     */
    @Column(name = "fee_cur")
    private String feeCur;

    /**
     * 成交汇率
     */
    @Column(name = "fin_rate")
    private BigDecimal finRate;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySupplierBatDtl other = (JsPaySupplierBatDtl) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getSeqNo() == null ? other.getSeqNo() == null : this.getSeqNo().equals(other.getSeqNo()))
            && (this.getBusinessNo() == null ? other.getBusinessNo() == null : this.getBusinessNo().equals(other.getBusinessNo()))
            && (this.getSupplierId() == null ? other.getSupplierId() == null : this.getSupplierId().equals(other.getSupplierId()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getSubAcctNo() == null ? other.getSubAcctNo() == null : this.getSubAcctNo().equals(other.getSubAcctNo()))
            && (this.getStoreName() == null ? other.getStoreName() == null : this.getStoreName().equals(other.getStoreName()))
            && (this.getBeneficiaryId() == null ? other.getBeneficiaryId() == null : this.getBeneficiaryId().equals(other.getBeneficiaryId()))
            && (this.getRcvPhone() == null ? other.getRcvPhone() == null : this.getRcvPhone().equals(other.getRcvPhone()))
            && (this.getTradeDate() == null ? other.getTradeDate() == null : this.getTradeDate().equals(other.getTradeDate()))
            && (this.getTradeCur() == null ? other.getTradeCur() == null : this.getTradeCur().equals(other.getTradeCur()))
            && (this.getTradeAmt() == null ? other.getTradeAmt() == null : this.getTradeAmt().equals(other.getTradeAmt()))
            && (this.getGoodsName() == null ? other.getGoodsName() == null : this.getGoodsName().equals(other.getGoodsName()))
            && (this.getAmount() == null ? other.getAmount() == null : this.getAmount().equals(other.getAmount()))
            && (this.getPrice() == null ? other.getPrice() == null : this.getPrice().equals(other.getPrice()))
            && (this.getLogisticsWay() == null ? other.getLogisticsWay() == null : this.getLogisticsWay().equals(other.getLogisticsWay()))
            && (this.getPurchaseWay() == null ? other.getPurchaseWay() == null : this.getPurchaseWay().equals(other.getPurchaseWay()))
            && (this.getTradeType() == null ? other.getTradeType() == null : this.getTradeType().equals(other.getTradeType()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getFailReason() == null ? other.getFailReason() == null : this.getFailReason().equals(other.getFailReason()))
            && (this.getFailCode() == null ? other.getFailCode() == null : this.getFailCode().equals(other.getFailCode()))
            && (this.getLockNo() == null ? other.getLockNo() == null : this.getLockNo().equals(other.getLockNo()))
            && (this.getTxnNo() == null ? other.getTxnNo() == null : this.getTxnNo().equals(other.getTxnNo()))
            && (this.getPayAmt() == null ? other.getPayAmt() == null : this.getPayAmt().equals(other.getPayAmt()))
            && (this.getPayCur() == null ? other.getPayCur() == null : this.getPayCur().equals(other.getPayCur()))
            && (this.getFeeAmt() == null ? other.getFeeAmt() == null : this.getFeeAmt().equals(other.getFeeAmt()))
            && (this.getFeeCur() == null ? other.getFeeCur() == null : this.getFeeCur().equals(other.getFeeCur()))
            && (this.getFinRate() == null ? other.getFinRate() == null : this.getFinRate().equals(other.getFinRate()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getSeqNo() == null) ? 0 : getSeqNo().hashCode());
        result = prime * result + ((getBusinessNo() == null) ? 0 : getBusinessNo().hashCode());
        result = prime * result + ((getSupplierId() == null) ? 0 : getSupplierId().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getSubAcctNo() == null) ? 0 : getSubAcctNo().hashCode());
        result = prime * result + ((getStoreName() == null) ? 0 : getStoreName().hashCode());
        result = prime * result + ((getBeneficiaryId() == null) ? 0 : getBeneficiaryId().hashCode());
        result = prime * result + ((getRcvPhone() == null) ? 0 : getRcvPhone().hashCode());
        result = prime * result + ((getTradeDate() == null) ? 0 : getTradeDate().hashCode());
        result = prime * result + ((getTradeCur() == null) ? 0 : getTradeCur().hashCode());
        result = prime * result + ((getTradeAmt() == null) ? 0 : getTradeAmt().hashCode());
        result = prime * result + ((getGoodsName() == null) ? 0 : getGoodsName().hashCode());
        result = prime * result + ((getAmount() == null) ? 0 : getAmount().hashCode());
        result = prime * result + ((getPrice() == null) ? 0 : getPrice().hashCode());
        result = prime * result + ((getLogisticsWay() == null) ? 0 : getLogisticsWay().hashCode());
        result = prime * result + ((getPurchaseWay() == null) ? 0 : getPurchaseWay().hashCode());
        result = prime * result + ((getTradeType() == null) ? 0 : getTradeType().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getFailReason() == null) ? 0 : getFailReason().hashCode());
        result = prime * result + ((getFailCode() == null) ? 0 : getFailCode().hashCode());
        result = prime * result + ((getLockNo() == null) ? 0 : getLockNo().hashCode());
        result = prime * result + ((getTxnNo() == null) ? 0 : getTxnNo().hashCode());
        result = prime * result + ((getPayAmt() == null) ? 0 : getPayAmt().hashCode());
        result = prime * result + ((getPayCur() == null) ? 0 : getPayCur().hashCode());
        result = prime * result + ((getFeeAmt() == null) ? 0 : getFeeAmt().hashCode());
        result = prime * result + ((getFeeCur() == null) ? 0 : getFeeCur().hashCode());
        result = prime * result + ((getFinRate() == null) ? 0 : getFinRate().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}