package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.js.common.enums.SiteEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_kyc_charge")
public class JsKycCharge extends IBaseModel implements Serializable {
    /**
     * 注册信息表-用户表-主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 收费类型(RATE-汇差,SERVICE_CHARGE-手续费)
     */
    @Column(name = "charge_type")
    private String chargeType;

    /**
     * 归属类型（SELF-个人可用，ALL-所有账户可用）
     */
    @Column(name = "`belong to_type`")
    private String belongToType;

    /**
     * 比例-以精确到小数位计算eg:0.0007
     */
    @Column(name = "charge_scale")
    private BigDecimal chargeScale;

    /**
     * 店铺所在站点
     */
    @Column(name = "store_the_site")
    private SiteEnum storeTheSite;

    /**
     * 预留字段
     */
    private String reserved;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsKycCharge other = (JsKycCharge) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getChargeType() == null ? other.getChargeType() == null : this.getChargeType().equals(other.getChargeType()))
            && (this.getBelongToType() == null ? other.getBelongToType() == null : this.getBelongToType().equals(other.getBelongToType()))
            && (this.getChargeScale() == null ? other.getChargeScale() == null : this.getChargeScale().equals(other.getChargeScale()))
            && (this.getReserved() == null ? other.getReserved() == null : this.getReserved().equals(other.getReserved()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getChargeType() == null) ? 0 : getChargeType().hashCode());
        result = prime * result + ((getBelongToType() == null) ? 0 : getBelongToType().hashCode());
        result = prime * result + ((getChargeScale() == null) ? 0 : getChargeScale().hashCode());
        result = prime * result + ((getReserved() == null) ? 0 : getReserved().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}