package com.js.dal.dao.model;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Id;
import java.util.Date;

/**
 * @ClassName: IBaseModel
 * @Description: 通用model
 * @Author: yjzhao
 * @Create: 2019-05-22  11:38
 **/
@Setter
@Getter
public class IBaseModel {
    /** id */
    @Id
    // @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "JDBC") 如果使用批处理功能，需要加上这个注解
    private String id;

    /** 是否删除[0:不删除, 1:删除] */
    @Column(name = "del_flag")
    private Boolean delFlag;

    /** 备注 */
    @Column(name = "js_remark")
    private String jsRemark;

    /** 创建人id */
    @Column(name = "create_id")
    private String createId;

    /** 创建人名称 */
    @Column(name = "create_name")
    private String createName;

    /** 创建日期 */
    @Column(name = "create_dts")
    private Date createDts;

    /** 创建人id */
    @Column(name = "update_id")
    private String updateId;

    /** 创建人名称 */
    @Column(name = "update_name")
    private String updateName;

    /** 更新时间 */
    @Column(name = "update_dts")
    private Date updateDts;
}
