package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "platform_store_status_statistics")
public class PlatformStoreStatusStatistics extends IBaseModel implements Serializable {
    /**
     * 用户 id
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 取消授权店铺占比
     */
    @Column(name = "cancel_shop_auth_ratio")
    private BigDecimal cancelShopAuthRatio;

    /**
     * 授权失败店铺占比
     */
    @Column(name = "fail_shop_auth_ratio")
    private BigDecimal failShopAuthRatio;

    /**
     * 关闭店铺占比
     */
    @Column(name = "close_shop_ratio")
    private BigDecimal closeShopRatio;

    /**
     * 统计时间
     */
    @Column(name = "statistics_time")
    private Date statisticsTime;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PlatformStoreStatusStatistics other = (PlatformStoreStatusStatistics) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getCancelShopAuthRatio() == null ? other.getCancelShopAuthRatio() == null : this.getCancelShopAuthRatio().equals(other.getCancelShopAuthRatio()))
            && (this.getFailShopAuthRatio() == null ? other.getFailShopAuthRatio() == null : this.getFailShopAuthRatio().equals(other.getFailShopAuthRatio()))
            && (this.getCloseShopRatio() == null ? other.getCloseShopRatio() == null : this.getCloseShopRatio().equals(other.getCloseShopRatio()))
            && (this.getStatisticsTime() == null ? other.getStatisticsTime() == null : this.getStatisticsTime().equals(other.getStatisticsTime()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getCancelShopAuthRatio() == null) ? 0 : getCancelShopAuthRatio().hashCode());
        result = prime * result + ((getFailShopAuthRatio() == null) ? 0 : getFailShopAuthRatio().hashCode());
        result = prime * result + ((getCloseShopRatio() == null) ? 0 : getCloseShopRatio().hashCode());
        result = prime * result + ((getStatisticsTime() == null) ? 0 : getStatisticsTime().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}