package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_loan_lender")
public class JsPayLoanLender extends IBaseModel implements Serializable {
    /**
     * 支付平台(1:汇付,2:富友,3:宝付)
     */
    @Column(name = "acct_type")
    private Byte acctType;

    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 组织机构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 银行卡id
     */
    @Column(name = "bank_id")
    private String bankId;

    /**
     * 放款银行所在地区（如：HK、CN、JP。）
     */
    @Column(name = "bank_country_code")
    private String bankCountryCode;

    /**
     * 放款银行名称
     */
    @Column(name = "bank_name")
    private String bankName;

    /**
     * 放款银行地址
     */
    @Column(name = "bank_addr")
    private String bankAddr;

    /**
     * 放款账户名称
     */
    @Column(name = "cus_name")
    private String cusName;

    /**
     * 放款账号
     */
    @Column(name = "bank_card_no")
    private String bankCardNo;

    /**
     * 账户余额
     */
    @Column(name = "available_amt")
    private BigDecimal availableAmt;

    /**
     * 冻结金额
     */
    @Column(name = "frozen_amt")
    private BigDecimal frozenAmt;

    /**
     * 昨日余额
     */
    @Column(name = "last_amt")
    private BigDecimal lastAmt;

    /**
     * 币种(如：USD)
     */
    @Column(name = "cur_id")
    private String curId;

    /**
     * aba
     */
    private String aba;

    /**
     * iban
     */
    private String iban;

    /**
     * swiftcode
     */
    @Column(name = "swift_code")
    private String swiftCode;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPayLoanLender other = (JsPayLoanLender) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getAcctType() == null ? other.getAcctType() == null : this.getAcctType().equals(other.getAcctType()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getBankId() == null ? other.getBankId() == null : this.getBankId().equals(other.getBankId()))
            && (this.getBankCountryCode() == null ? other.getBankCountryCode() == null : this.getBankCountryCode().equals(other.getBankCountryCode()))
            && (this.getBankName() == null ? other.getBankName() == null : this.getBankName().equals(other.getBankName()))
            && (this.getBankAddr() == null ? other.getBankAddr() == null : this.getBankAddr().equals(other.getBankAddr()))
            && (this.getCusName() == null ? other.getCusName() == null : this.getCusName().equals(other.getCusName()))
            && (this.getBankCardNo() == null ? other.getBankCardNo() == null : this.getBankCardNo().equals(other.getBankCardNo()))
            && (this.getAvailableAmt() == null ? other.getAvailableAmt() == null : this.getAvailableAmt().equals(other.getAvailableAmt()))
            && (this.getFrozenAmt() == null ? other.getFrozenAmt() == null : this.getFrozenAmt().equals(other.getFrozenAmt()))
            && (this.getLastAmt() == null ? other.getLastAmt() == null : this.getLastAmt().equals(other.getLastAmt()))
            && (this.getCurId() == null ? other.getCurId() == null : this.getCurId().equals(other.getCurId()))
            && (this.getAba() == null ? other.getAba() == null : this.getAba().equals(other.getAba()))
            && (this.getIban() == null ? other.getIban() == null : this.getIban().equals(other.getIban()))
            && (this.getSwiftCode() == null ? other.getSwiftCode() == null : this.getSwiftCode().equals(other.getSwiftCode()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getAcctType() == null) ? 0 : getAcctType().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getBankId() == null) ? 0 : getBankId().hashCode());
        result = prime * result + ((getBankCountryCode() == null) ? 0 : getBankCountryCode().hashCode());
        result = prime * result + ((getBankName() == null) ? 0 : getBankName().hashCode());
        result = prime * result + ((getBankAddr() == null) ? 0 : getBankAddr().hashCode());
        result = prime * result + ((getCusName() == null) ? 0 : getCusName().hashCode());
        result = prime * result + ((getBankCardNo() == null) ? 0 : getBankCardNo().hashCode());
        result = prime * result + ((getAvailableAmt() == null) ? 0 : getAvailableAmt().hashCode());
        result = prime * result + ((getFrozenAmt() == null) ? 0 : getFrozenAmt().hashCode());
        result = prime * result + ((getLastAmt() == null) ? 0 : getLastAmt().hashCode());
        result = prime * result + ((getCurId() == null) ? 0 : getCurId().hashCode());
        result = prime * result + ((getAba() == null) ? 0 : getAba().hashCode());
        result = prime * result + ((getIban() == null) ? 0 : getIban().hashCode());
        result = prime * result + ((getSwiftCode() == null) ? 0 : getSwiftCode().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}