package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;

@Table(name = "js_comm_file_resource")
@Getter
@Setter
public class JsCommFileResource extends IBaseModel implements Serializable {
    /**
     * 存放位置
     */
    @Column(name = "file_save_path")
    private String fileSavePath;

    /**
     * 显示位置
     */
    @Column(name = "file_show_path")
    private String fileShowPath;

    /**
     * 存放名称
     */
    @Column(name = "file_save_name")
    private String fileSaveName;

    /**
     * 显示名称
     */
    @Column(name = "file_show_name")
    private String fileShowName;

    /**
     * 文件缩略图存放地址
     */
    @Column(name = "file_thumbnail_path")
    private String fileThumbnailPath;

    /**
     * 文件类型[0:文档, 1:图片 ,2:视频, 3:其他]
     */
    @Column(name = "file_type")
    private Integer fileType;

    /**
     * 文件扩展名
     */
    @Column(name = "file_ext")
    private String fileExt;

    /**
     * 文件大小
     */
    @Column(name = "file_size")
    private Integer fileSize;

    /**
     * 文件来源类型[0:通用, 1:实名证件, 2:合同文件, 3:生成交易报表]
     */
    @Column(name = "file_resource_type")
    private Integer fileResourceType;

    @Column(name = "js_remark")
    private String jsRemark;

    private static final long serialVersionUID = 1L;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", fileSavePath=").append(fileSavePath);
        sb.append(", fileShowPath=").append(fileShowPath);
        sb.append(", fileSaveName=").append(fileSaveName);
        sb.append(", fileShowName=").append(fileShowName);
        sb.append(", fileThumbnailPath=").append(fileThumbnailPath);
        sb.append(", fileType=").append(fileType);
        sb.append(", fileExt=").append(fileExt);
        sb.append(", fileSize=").append(fileSize);
        sb.append(", fileResourceType=").append(fileResourceType);
        sb.append(", jsRemark=").append(jsRemark);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsCommFileResource other = (JsCommFileResource) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getFileSavePath() == null ? other.getFileSavePath() == null : this.getFileSavePath().equals(other.getFileSavePath()))
            && (this.getFileShowPath() == null ? other.getFileShowPath() == null : this.getFileShowPath().equals(other.getFileShowPath()))
            && (this.getFileSaveName() == null ? other.getFileSaveName() == null : this.getFileSaveName().equals(other.getFileSaveName()))
            && (this.getFileShowName() == null ? other.getFileShowName() == null : this.getFileShowName().equals(other.getFileShowName()))
            && (this.getFileThumbnailPath() == null ? other.getFileThumbnailPath() == null : this.getFileThumbnailPath().equals(other.getFileThumbnailPath()))
            && (this.getFileType() == null ? other.getFileType() == null : this.getFileType().equals(other.getFileType()))
            && (this.getFileExt() == null ? other.getFileExt() == null : this.getFileExt().equals(other.getFileExt()))
            && (this.getFileSize() == null ? other.getFileSize() == null : this.getFileSize().equals(other.getFileSize()))
            && (this.getFileResourceType() == null ? other.getFileResourceType() == null : this.getFileResourceType().equals(other.getFileResourceType()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getFileSavePath() == null) ? 0 : getFileSavePath().hashCode());
        result = prime * result + ((getFileShowPath() == null) ? 0 : getFileShowPath().hashCode());
        result = prime * result + ((getFileSaveName() == null) ? 0 : getFileSaveName().hashCode());
        result = prime * result + ((getFileShowName() == null) ? 0 : getFileShowName().hashCode());
        result = prime * result + ((getFileThumbnailPath() == null) ? 0 : getFileThumbnailPath().hashCode());
        result = prime * result + ((getFileType() == null) ? 0 : getFileType().hashCode());
        result = prime * result + ((getFileExt() == null) ? 0 : getFileExt().hashCode());
        result = prime * result + ((getFileSize() == null) ? 0 : getFileSize().hashCode());
        result = prime * result + ((getFileResourceType() == null) ? 0 : getFileResourceType().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}