package com.base;

import org.apache.ibatis.annotations.InsertProvider;
import tk.mybatis.mapper.annotation.RegisterMapper;
import tk.mybatis.mapper.common.Mapper;
import tk.mybatis.mapper.common.MySqlMapper;

import java.util.List;

/**
 * @ClassName: IBaseMapper
 * @Description: 通用mapper
 * @Author: yjzhao com.js.dal.dao.mapper.IBaseMapper
 * @Create: 2019-05-22  11:06
 **/
@RegisterMapper
public interface IBaseMapper<T> extends Mapper<T>, MySqlMapper<T> {

    /**
     * 批量插入，支持批量插入的数据库可以使用，例如MySQL,H2等，该接口实体包含`id`属性并且必须有值。
     *
     * @param recordList
     * @return
     */
    @InsertProvider(type = SpecialProvider.class, method = "dynamicSQL")
    int insertListWithKey(List<? extends T> recordList);

}
