package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "china_pnr_transaction_detail")
public class ChinaPnrTransactionDetail extends IBaseModel implements Serializable {
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    @Column(name = "store_id")
    private String storeId;

    @Column(name = "kyc_bank_id")
    private String kycBankId;

    /**
     * 提现批次号
     */
    @Column(name = "batch_no")
    private String batchNo;

    /**
     * 交易备案 id
     */
    @Column(name = "transaction_id")
    private String transactionId;

    /**
     * 交易类型
     */
    @Column(name = "transaction_type")
    private String transactionType;

    /**
     * 结算报告 id
     */
    @Column(name = "settlement_id")
    private String settlementId;

    /**
     * 商品的 sku
     */
    private String sku;

    /**
     * 商品代码,对应商品明细中的 id
     */
    @Column(name = "order_item_code")
    private String orderItemCode;

    /**
     * 源币种类型
     */
    @Column(name = "currency_code")
    private String currencyCode;

    /**
     * 源币种总金额
     */
    @Column(name = "order_price_total")
    private BigDecimal orderPriceTotal;

    /**
     * 汇率
     */
    @Column(name = "exchange_rate")
    private BigDecimal exchangeRate;

    /**
     * 拆分出来的源币种金额
     */
    @Column(name = "split_source_amount")
    private BigDecimal splitSourceAmount;

    /**
     * 拆分后换汇得到的金额
     */
    @Column(name = "split_amount")
    private BigDecimal splitAmount;

    /**
     * 是否拆分过 0 未拆分，1 已折分
     */
    @Column(name = "split_flag")
    private Boolean splitFlag;

    /**
     * 商品的到货日期
     */
    @Column(name = "posted_date")
    private Date postedDate;

    /**
     * 执行状态
     */
    @Column(name = "status")
    private String status;
    /**
     * 交易时间
     */
    @Column(name = "trade_date")
    private Date tradeDate;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ChinaPnrTransactionDetail other = (ChinaPnrTransactionDetail) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getKycBankId() == null ? other.getKycBankId() == null : this.getKycBankId().equals(other.getKycBankId()))
            && (this.getBatchNo() == null ? other.getBatchNo() == null : this.getBatchNo().equals(other.getBatchNo()))
            && (this.getTransactionId() == null ? other.getTransactionId() == null : this.getTransactionId().equals(other.getTransactionId()))
            && (this.getTransactionType() == null ? other.getTransactionType() == null : this.getTransactionType().equals(other.getTransactionType()))
            && (this.getSettlementId() == null ? other.getSettlementId() == null : this.getSettlementId().equals(other.getSettlementId()))
            && (this.getSku() == null ? other.getSku() == null : this.getSku().equals(other.getSku()))
            && (this.getOrderItemCode() == null ? other.getOrderItemCode() == null : this.getOrderItemCode().equals(other.getOrderItemCode()))
            && (this.getCurrencyCode() == null ? other.getCurrencyCode() == null : this.getCurrencyCode().equals(other.getCurrencyCode()))
            && (this.getOrderPriceTotal() == null ? other.getOrderPriceTotal() == null : this.getOrderPriceTotal().equals(other.getOrderPriceTotal()))
            && (this.getExchangeRate() == null ? other.getExchangeRate() == null : this.getExchangeRate().equals(other.getExchangeRate()))
            && (this.getSplitSourceAmount() == null ? other.getSplitSourceAmount() == null : this.getSplitSourceAmount().equals(other.getSplitSourceAmount()))
            && (this.getSplitAmount() == null ? other.getSplitAmount() == null : this.getSplitAmount().equals(other.getSplitAmount()))
            && (this.getSplitFlag() == null ? other.getSplitFlag() == null : this.getSplitFlag().equals(other.getSplitFlag()))
            && (this.getPostedDate() == null ? other.getPostedDate() == null : this.getPostedDate().equals(other.getPostedDate()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getTradeDate() == null ? other.getTradeDate() == null : this.getTradeDate().equals(other.getTradeDate()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getKycBankId() == null) ? 0 : getKycBankId().hashCode());
        result = prime * result + ((getBatchNo() == null) ? 0 : getBatchNo().hashCode());
        result = prime * result + ((getTransactionId() == null) ? 0 : getTransactionId().hashCode());
        result = prime * result + ((getTransactionType() == null) ? 0 : getTransactionType().hashCode());
        result = prime * result + ((getSettlementId() == null) ? 0 : getSettlementId().hashCode());
        result = prime * result + ((getSku() == null) ? 0 : getSku().hashCode());
        result = prime * result + ((getOrderItemCode() == null) ? 0 : getOrderItemCode().hashCode());
        result = prime * result + ((getCurrencyCode() == null) ? 0 : getCurrencyCode().hashCode());
        result = prime * result + ((getOrderPriceTotal() == null) ? 0 : getOrderPriceTotal().hashCode());
        result = prime * result + ((getExchangeRate() == null) ? 0 : getExchangeRate().hashCode());
        result = prime * result + ((getSplitSourceAmount() == null) ? 0 : getSplitSourceAmount().hashCode());
        result = prime * result + ((getSplitAmount() == null) ? 0 : getSplitAmount().hashCode());
        result = prime * result + ((getSplitFlag() == null) ? 0 : getSplitFlag().hashCode());
        result = prime * result + ((getPostedDate() == null) ? 0 : getPostedDate().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getTradeDate() == null) ? 0 : getTradeDate().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}