package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "fadada_contract")
public class FadadaContract extends IBaseModel implements Serializable {
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 贷款申请编号,一整份合同公用一个
     */
    @Column(name = "loan_no")
    private String loanNo;

    /**
     * 合同id
     */
    @Column(name = "contract_id")
    private String contractId;

    /**
     * 合同名称
     */
    @Column(name = "doc_title")
    private String docTitle;

    /**
     * 公网可下载到合同的 url 地址
     */
    @Column(name = "doc_url")
    private String docUrl;

    /**
     * 法大大合同下载地址
     */
    @Column(name = "fadada_download_url")
    private String fadadaDownloadUrl;

    /**
     * 法大大合同查看地址
     */
    @Column(name = "fadada_select_url")
    private String fadadaSelectUrl;

    /**
     * oss 文件存储路径
     */
    @Column(name = "file_save_path")
    private String fileSavePath;

    /**
     * 固定 pdf
     */
    @Column(name = "doc_type")
    private String docType;

    /**
     * 合同的签署状态 0:签署中 1:已归档。
     */
    private Integer status;

    /**
     * 法大大合同上传结果
     */
    private String result;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        FadadaContract other = (FadadaContract) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getLoanNo() == null ? other.getLoanNo() == null : this.getLoanNo().equals(other.getLoanNo()))
            && (this.getContractId() == null ? other.getContractId() == null : this.getContractId().equals(other.getContractId()))
            && (this.getDocTitle() == null ? other.getDocTitle() == null : this.getDocTitle().equals(other.getDocTitle()))
            && (this.getDocUrl() == null ? other.getDocUrl() == null : this.getDocUrl().equals(other.getDocUrl()))
            && (this.getFadadaDownloadUrl() == null ? other.getFadadaDownloadUrl() == null : this.getFadadaDownloadUrl().equals(other.getFadadaDownloadUrl()))
            && (this.getFadadaSelectUrl() == null ? other.getFadadaSelectUrl() == null : this.getFadadaSelectUrl().equals(other.getFadadaSelectUrl()))
            && (this.getFileSavePath() == null ? other.getFileSavePath() == null : this.getFileSavePath().equals(other.getFileSavePath()))
            && (this.getDocType() == null ? other.getDocType() == null : this.getDocType().equals(other.getDocType()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getResult() == null ? other.getResult() == null : this.getResult().equals(other.getResult()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getLoanNo() == null) ? 0 : getLoanNo().hashCode());
        result = prime * result + ((getContractId() == null) ? 0 : getContractId().hashCode());
        result = prime * result + ((getDocTitle() == null) ? 0 : getDocTitle().hashCode());
        result = prime * result + ((getDocUrl() == null) ? 0 : getDocUrl().hashCode());
        result = prime * result + ((getFadadaDownloadUrl() == null) ? 0 : getFadadaDownloadUrl().hashCode());
        result = prime * result + ((getFadadaSelectUrl() == null) ? 0 : getFadadaSelectUrl().hashCode());
        result = prime * result + ((getFileSavePath() == null) ? 0 : getFileSavePath().hashCode());
        result = prime * result + ((getDocType() == null) ? 0 : getDocType().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getResult() == null) ? 0 : getResult().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}