package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "platform_statistics_by_shop")
public class PlatformStatisticsByStore extends IBaseModel implements Serializable {
    /**
     * 用户 id
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 店铺 id
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 总月均销售额
     */
    @Column(name = "monthly_sale")
    private BigDecimal monthlySale;

    /**
     * 笔均入账金额
     */
    @Column(name = "average_income")
    private BigDecimal averageIncome;

    /**
     * 平均客单价
     */
    @Column(name = "per_customer_transaction")
    private BigDecimal perCustomerTransaction;

    /**
     * 月均退款额
     */
    @Column(name = "refund_amount")
    private BigDecimal refundAmount;

    /**
     * 总税率
     */
    @Column(name = "tax_rate")
    private BigDecimal taxRate;

    /**
     * 平均订单数
     */
    @Column(name = "average_order_num")
    private BigDecimal averageOrderNum;

    /**
     * 平均SKU数量
     */
    @Column(name = "average_sku")
    private BigDecimal averageSku;

    /**
     * 统计时间
     */
    @Column(name = "statistics_time")
    private Date statisticsTime;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PlatformStatisticsByStore other = (PlatformStatisticsByStore) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getMonthlySale() == null ? other.getMonthlySale() == null : this.getMonthlySale().equals(other.getMonthlySale()))
            && (this.getAverageIncome() == null ? other.getAverageIncome() == null : this.getAverageIncome().equals(other.getAverageIncome()))
            && (this.getPerCustomerTransaction() == null ? other.getPerCustomerTransaction() == null : this.getPerCustomerTransaction().equals(other.getPerCustomerTransaction()))
            && (this.getRefundAmount() == null ? other.getRefundAmount() == null : this.getRefundAmount().equals(other.getRefundAmount()))
            && (this.getTaxRate() == null ? other.getTaxRate() == null : this.getTaxRate().equals(other.getTaxRate()))
            && (this.getAverageOrderNum() == null ? other.getAverageOrderNum() == null : this.getAverageOrderNum().equals(other.getAverageOrderNum()))
            && (this.getAverageSku() == null ? other.getAverageSku() == null : this.getAverageSku().equals(other.getAverageSku()))
            && (this.getStatisticsTime() == null ? other.getStatisticsTime() == null : this.getStatisticsTime().equals(other.getStatisticsTime()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getMonthlySale() == null) ? 0 : getMonthlySale().hashCode());
        result = prime * result + ((getAverageIncome() == null) ? 0 : getAverageIncome().hashCode());
        result = prime * result + ((getPerCustomerTransaction() == null) ? 0 : getPerCustomerTransaction().hashCode());
        result = prime * result + ((getRefundAmount() == null) ? 0 : getRefundAmount().hashCode());
        result = prime * result + ((getTaxRate() == null) ? 0 : getTaxRate().hashCode());
        result = prime * result + ((getAverageOrderNum() == null) ? 0 : getAverageOrderNum().hashCode());
        result = prime * result + ((getAverageSku() == null) ? 0 : getAverageSku().hashCode());
        result = prime * result + ((getStatisticsTime() == null) ? 0 : getStatisticsTime().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}