package com.js.dal.dao.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "kyc_certi_mainland_company")
public class KycCertiMainLandCompany extends IBaseModel implements Serializable {
    /**
     * 注册表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 企业名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 企业英文名称
     */
    @Column(name = "company_eng_name")
    private String companyEngName;

    /**
     * 营业执照生效日期
     */
    @Column(name = "biz_license_exp_date_start")
    private Date bizLicenseExpDateStart;

    /**
     * 营业执照失效日期
     */
    @Column(name = "biz_license_exp_date_end")
    private Date bizLicenseExpDateEnd;

    /**
     * 统一社会信用代码
     */
    @Column(name = "unified_social_credit_code")
    private String unifiedSocialCreditCode;

    /**
     * 企业性质ID
     */
    @Column(name = "company_nature_id")
    private String companyNatureId;

    /**
     * 企业性质名称
     */
    @Column(name = "company_nature_name")
    private String companyNatureName;

    /**
     * 店铺主要经营类别表ID
     */
    @Column(name = "store_business_type_id")
    private String storeBusinessTypeId;

    /**
     * 店铺主要经营类别名称
     */
    @Column(name = "store_business_type_name")
    private String storeBusinessTypeName;

    /**
     * 法定代表人证件类型ID
     */
    @Column(name = "legal_representative_id_type")
    private String legalRepresentativeIdType;

    /**
     * 法定代表人证件类型名称
     */
    @Column(name = "legal_representative_id_type_name")
    private String legalRepresentativeIdTypeName;

    /**
     * 法定代表人姓名
     */
    @Column(name = "legal_representative_name")
    private String legalRepresentativeName;

    /**
     * 法定代表人证件号
     */
    @Column(name = "legal_representative_id_no")
    private String legalRepresentativeIdNo;

    /**
     * 法定代表人住址
     */
    @Column(name = "legal_representative_address")
    private String legalRepresentativeAddress;

    /**
     * 身份证有效起始日期
     */
    @Column(name = "effective_start_time")
    private Date effectiveStartTime;

    /**
     * 身份证有效截止日期
     */
    @Column(name = "effective_end_time")
    private Date effectiveEndTime;

    /**
     * 是否长期有效(0:非长期，1：长期)
     */
    @Column(name = "long_flag")
    private Boolean longFlag;

    /**
     * 企业经营地址
     */
    @Column(name = "company_address")
    private String companyAddress;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        KycCertiMainLandCompany other = (KycCertiMainLandCompany) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getCompanyName() == null ? other.getCompanyName() == null : this.getCompanyName().equals(other.getCompanyName()))
            && (this.getCompanyEngName() == null ? other.getCompanyEngName() == null : this.getCompanyEngName().equals(other.getCompanyEngName()))
            && (this.getUnifiedSocialCreditCode() == null ? other.getUnifiedSocialCreditCode() == null : this.getUnifiedSocialCreditCode().equals(other.getUnifiedSocialCreditCode()))
            && (this.getCompanyNatureId() == null ? other.getCompanyNatureId() == null : this.getCompanyNatureId().equals(other.getCompanyNatureId()))
            && (this.getCompanyNatureName() == null ? other.getCompanyNatureName() == null : this.getCompanyNatureName().equals(other.getCompanyNatureName()))
            && (this.getStoreBusinessTypeId() == null ? other.getStoreBusinessTypeId() == null : this.getStoreBusinessTypeId().equals(other.getStoreBusinessTypeId()))
            && (this.getStoreBusinessTypeName() == null ? other.getStoreBusinessTypeName() == null : this.getStoreBusinessTypeName().equals(other.getStoreBusinessTypeName()))
            && (this.getLegalRepresentativeIdType() == null ? other.getLegalRepresentativeIdType() == null : this.getLegalRepresentativeIdType().equals(other.getLegalRepresentativeIdType()))
            && (this.getLegalRepresentativeIdTypeName() == null ? other.getLegalRepresentativeIdTypeName() == null : this.getLegalRepresentativeIdTypeName().equals(other.getLegalRepresentativeIdTypeName()))
            && (this.getLegalRepresentativeName() == null ? other.getLegalRepresentativeName() == null : this.getLegalRepresentativeName().equals(other.getLegalRepresentativeName()))
            && (this.getLegalRepresentativeIdNo() == null ? other.getLegalRepresentativeIdNo() == null : this.getLegalRepresentativeIdNo().equals(other.getLegalRepresentativeIdNo()))
            && (this.getLegalRepresentativeAddress() == null ? other.getLegalRepresentativeAddress() == null : this.getLegalRepresentativeAddress().equals(other.getLegalRepresentativeAddress()))
            && (this.getEffectiveStartTime() == null ? other.getEffectiveStartTime() == null : this.getEffectiveStartTime().equals(other.getEffectiveStartTime()))
            && (this.getEffectiveEndTime() == null ? other.getEffectiveEndTime() == null : this.getEffectiveEndTime().equals(other.getEffectiveEndTime()))
            && (this.getLongFlag() == null ? other.getLongFlag() == null : this.getLongFlag().equals(other.getLongFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCompanyAddress() == null ? other.getCompanyAddress() == null : this.getCompanyAddress().equals(other.getCompanyAddress()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getCompanyName() == null) ? 0 : getCompanyName().hashCode());
        result = prime * result + ((getCompanyEngName() == null) ? 0 : getCompanyEngName().hashCode());
        result = prime * result + ((getUnifiedSocialCreditCode() == null) ? 0 : getUnifiedSocialCreditCode().hashCode());
        result = prime * result + ((getCompanyNatureId() == null) ? 0 : getCompanyNatureId().hashCode());
        result = prime * result + ((getCompanyNatureName() == null) ? 0 : getCompanyNatureName().hashCode());
        result = prime * result + ((getStoreBusinessTypeId() == null) ? 0 : getStoreBusinessTypeId().hashCode());
        result = prime * result + ((getStoreBusinessTypeName() == null) ? 0 : getStoreBusinessTypeName().hashCode());
        result = prime * result + ((getLegalRepresentativeIdType() == null) ? 0 : getLegalRepresentativeIdType().hashCode());
        result = prime * result + ((getLegalRepresentativeIdTypeName() == null) ? 0 : getLegalRepresentativeIdTypeName().hashCode());
        result = prime * result + ((getLegalRepresentativeName() == null) ? 0 : getLegalRepresentativeName().hashCode());
        result = prime * result + ((getLegalRepresentativeIdNo() == null) ? 0 : getLegalRepresentativeIdNo().hashCode());
        result = prime * result + ((getLegalRepresentativeAddress() == null) ? 0 : getLegalRepresentativeAddress().hashCode());
        result = prime * result + ((getEffectiveStartTime() == null) ? 0 : getEffectiveStartTime().hashCode());
        result = prime * result + ((getEffectiveEndTime() == null) ? 0 : getEffectiveEndTime().hashCode());
        result = prime * result + ((getLongFlag() == null) ? 0 : getLongFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCompanyAddress() == null) ? 0 : getCompanyAddress().hashCode());
        return result;
    }
}