package com.js.dal.dao.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "kyc_certi_hk_company")
public class KycCertiHKCompany extends IBaseModel implements Serializable {
    /**
     * 注册表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 企业名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 企业英文名称
     */
    @Column(name = "company_eng_name")
    private String companyEngName;

    /**
     * 公司注册证书编号
     */
    @Column(name = "company_registered_certificate_no")
    private String companyRegisteredCertificateNo;

    /**
     * 企业性质ID
     */
    @Column(name = "company_nature_id")
    private String companyNatureId;

    /**
     * 企业性质
     */
    @Column(name = "company_nature")
    private String companyNature;

    /**
     * 店铺主要经营类别表ID
     */
    @Column(name = "store_business_type_id")
    private String storeBusinessTypeId;

    /**
     * 店铺主要经营类别名称
     */
    @Column(name = "store_business_type_name")
    private String storeBusinessTypeName;

    /**
     * 董事证件类型ID
     */
    @Column(name = "director_id_type")
    private String directorIdType;

    /**
     * 董事证件类型名称
     */
    @Column(name = "director_id_type_name")
    private String directorIdTypeName;

    /**
     * 董事姓名
     */
    @Column(name = "director_name")
    private String directorName;

    /**
     * 董事证件号
     */
    @Column(name = "director_id_no")
    private String directorIdNo;

    /**
     * 董事住址
     */
    @Column(name = "director_address")
    private String directorAddress;

    /**
     * 身份证有效起始日期
     */
    @Column(name = "effective_start_time")
    private Date effectiveStartTime;

    /**
     * 身份证有效截止日期
     */
    @Column(name = "effective_end_time")
    private Date effectiveEndTime;

    /**
     * 是否长期有效(0:非长期，1：长期)
     */
    @Column(name = "long_flag")
    private Boolean longFlag;

    /**
     * 企业经营地址
     */
    @Column(name = "company_address")
    private String companyAddress;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        KycCertiHKCompany other = (KycCertiHKCompany) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getCompanyName() == null ? other.getCompanyName() == null : this.getCompanyName().equals(other.getCompanyName()))
            && (this.getCompanyEngName() == null ? other.getCompanyEngName() == null : this.getCompanyEngName().equals(other.getCompanyEngName()))
            && (this.getCompanyRegisteredCertificateNo() == null ? other.getCompanyRegisteredCertificateNo() == null : this.getCompanyRegisteredCertificateNo().equals(other.getCompanyRegisteredCertificateNo()))
            && (this.getCompanyNatureId() == null ? other.getCompanyNatureId() == null : this.getCompanyNatureId().equals(other.getCompanyNatureId()))
            && (this.getCompanyNature() == null ? other.getCompanyNature() == null : this.getCompanyNature().equals(other.getCompanyNature()))
            && (this.getStoreBusinessTypeId() == null ? other.getStoreBusinessTypeId() == null : this.getStoreBusinessTypeId().equals(other.getStoreBusinessTypeId()))
            && (this.getStoreBusinessTypeName() == null ? other.getStoreBusinessTypeName() == null : this.getStoreBusinessTypeName().equals(other.getStoreBusinessTypeName()))
            && (this.getDirectorIdType() == null ? other.getDirectorIdType() == null : this.getDirectorIdType().equals(other.getDirectorIdType()))
            && (this.getDirectorIdTypeName() == null ? other.getDirectorIdTypeName() == null : this.getDirectorIdTypeName().equals(other.getDirectorIdTypeName()))
            && (this.getDirectorName() == null ? other.getDirectorName() == null : this.getDirectorName().equals(other.getDirectorName()))
            && (this.getDirectorIdNo() == null ? other.getDirectorIdNo() == null : this.getDirectorIdNo().equals(other.getDirectorIdNo()))
            && (this.getDirectorAddress() == null ? other.getDirectorAddress() == null : this.getDirectorAddress().equals(other.getDirectorAddress()))
            && (this.getEffectiveStartTime() == null ? other.getEffectiveStartTime() == null : this.getEffectiveStartTime().equals(other.getEffectiveStartTime()))
            && (this.getEffectiveEndTime() == null ? other.getEffectiveEndTime() == null : this.getEffectiveEndTime().equals(other.getEffectiveEndTime()))
            && (this.getLongFlag() == null ? other.getLongFlag() == null : this.getLongFlag().equals(other.getLongFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCompanyAddress() == null ? other.getCompanyAddress() == null : this.getCompanyAddress().equals(other.getCompanyAddress()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getCompanyName() == null) ? 0 : getCompanyName().hashCode());
        result = prime * result + ((getCompanyEngName() == null) ? 0 : getCompanyEngName().hashCode());
        result = prime * result + ((getCompanyRegisteredCertificateNo() == null) ? 0 : getCompanyRegisteredCertificateNo().hashCode());
        result = prime * result + ((getCompanyNatureId() == null) ? 0 : getCompanyNatureId().hashCode());
        result = prime * result + ((getCompanyNature() == null) ? 0 : getCompanyNature().hashCode());
        result = prime * result + ((getStoreBusinessTypeId() == null) ? 0 : getStoreBusinessTypeId().hashCode());
        result = prime * result + ((getStoreBusinessTypeName() == null) ? 0 : getStoreBusinessTypeName().hashCode());
        result = prime * result + ((getDirectorIdType() == null) ? 0 : getDirectorIdType().hashCode());
        result = prime * result + ((getDirectorIdTypeName() == null) ? 0 : getDirectorIdTypeName().hashCode());
        result = prime * result + ((getDirectorName() == null) ? 0 : getDirectorName().hashCode());
        result = prime * result + ((getDirectorIdNo() == null) ? 0 : getDirectorIdNo().hashCode());
        result = prime * result + ((getDirectorAddress() == null) ? 0 : getDirectorAddress().hashCode());
        result = prime * result + ((getEffectiveStartTime() == null) ? 0 : getEffectiveStartTime().hashCode());
        result = prime * result + ((getEffectiveEndTime() == null) ? 0 : getEffectiveEndTime().hashCode());
        result = prime * result + ((getLongFlag() == null) ? 0 : getLongFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCompanyAddress() == null) ? 0 : getCompanyAddress().hashCode());
        return result;
    }
}