package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_user_loan_receipt")
public class JsPayUserLoanReceipt extends IBaseModel implements Serializable {
    /**
     * 用户id
     */
    @Column(name = "user_id")
    private String userId;

    /**
     * 组织机构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 收款银行所在地区
     */
    @Column(name = "bank_country_code")
    private String bankCountryCode;

    /**
     * 收款银行名称
     */
    @Column(name = "bank_name")
    private String bankName;

    /**
     * 收款银行地址
     */
    @Column(name = "bank_addr")
    private String bankAddr;

    /**
     * 收款银行账户名称
     */
    @Column(name = "cus_name")
    private String cusName;

    /**
     * 收款银行账号
     */
    @Column(name = "bank_card_no")
    private String bankCardNo;

    /**
     * 账户余额
     */
    @Column(name = "available_amt")
    private BigDecimal availableAmt;

    /**
     * 冻结金额
     */
    @Column(name = "frozen_amt")
    private BigDecimal frozenAmt;

    /**
     * 昨日余额
     */
    @Column(name = "last_amt")
    private BigDecimal lastAmt;

    /**
     * 币种(如：USD)
     */
    @Column(name = "cur_id")
    private String curId;

    /**
     * 路由方式
     */
    @Column(name = "route_type")
    private String routeType;

    /**
     * swiftcode
     */
    @Column(name = "swift_code")
    private String swiftCode;

    /**
     * 账户持有人id
     */
    @Column(name = "store_hold_member")
    private Integer storeHoldMember;

    /**
     * 合作平台(0:寻汇,1:easypay)
     */
    @Column(name = "platform_type")
    private Integer platformType;

    /**
     * 是否为当前使用[0:不是, 1:是]
     */
    @Column(name = "use_flag")
    private Boolean useFlag;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPayUserLoanReceipt other = (JsPayUserLoanReceipt) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getUserId() == null ? other.getUserId() == null : this.getUserId().equals(other.getUserId()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getBankCountryCode() == null ? other.getBankCountryCode() == null : this.getBankCountryCode().equals(other.getBankCountryCode()))
            && (this.getBankName() == null ? other.getBankName() == null : this.getBankName().equals(other.getBankName()))
            && (this.getBankAddr() == null ? other.getBankAddr() == null : this.getBankAddr().equals(other.getBankAddr()))
            && (this.getCusName() == null ? other.getCusName() == null : this.getCusName().equals(other.getCusName()))
            && (this.getBankCardNo() == null ? other.getBankCardNo() == null : this.getBankCardNo().equals(other.getBankCardNo()))
            && (this.getAvailableAmt() == null ? other.getAvailableAmt() == null : this.getAvailableAmt().equals(other.getAvailableAmt()))
            && (this.getFrozenAmt() == null ? other.getFrozenAmt() == null : this.getFrozenAmt().equals(other.getFrozenAmt()))
            && (this.getLastAmt() == null ? other.getLastAmt() == null : this.getLastAmt().equals(other.getLastAmt()))
            && (this.getCurId() == null ? other.getCurId() == null : this.getCurId().equals(other.getCurId()))
            && (this.getRouteType() == null ? other.getRouteType() == null : this.getRouteType().equals(other.getRouteType()))
            && (this.getSwiftCode() == null ? other.getSwiftCode() == null : this.getSwiftCode().equals(other.getSwiftCode()))
            && (this.getStoreHoldMember() == null ? other.getStoreHoldMember() == null : this.getStoreHoldMember().equals(other.getStoreHoldMember()))
            && (this.getPlatformType() == null ? other.getPlatformType() == null : this.getPlatformType().equals(other.getPlatformType()))
            && (this.getUseFlag() == null ? other.getUseFlag() == null : this.getUseFlag().equals(other.getUseFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getUserId() == null) ? 0 : getUserId().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getBankCountryCode() == null) ? 0 : getBankCountryCode().hashCode());
        result = prime * result + ((getBankName() == null) ? 0 : getBankName().hashCode());
        result = prime * result + ((getBankAddr() == null) ? 0 : getBankAddr().hashCode());
        result = prime * result + ((getCusName() == null) ? 0 : getCusName().hashCode());
        result = prime * result + ((getBankCardNo() == null) ? 0 : getBankCardNo().hashCode());
        result = prime * result + ((getAvailableAmt() == null) ? 0 : getAvailableAmt().hashCode());
        result = prime * result + ((getFrozenAmt() == null) ? 0 : getFrozenAmt().hashCode());
        result = prime * result + ((getLastAmt() == null) ? 0 : getLastAmt().hashCode());
        result = prime * result + ((getCurId() == null) ? 0 : getCurId().hashCode());
        result = prime * result + ((getRouteType() == null) ? 0 : getRouteType().hashCode());
        result = prime * result + ((getSwiftCode() == null) ? 0 : getSwiftCode().hashCode());
        result = prime * result + ((getStoreHoldMember() == null) ? 0 : getStoreHoldMember().hashCode());
        result = prime * result + ((getPlatformType() == null) ? 0 : getPlatformType().hashCode());
        result = prime * result + ((getUseFlag() == null) ? 0 : getUseFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}