package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_sunrate_trade_query_price")
public class JsPaySunrateTradeQueryPrice extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    @Column(name = "kyc_sunrate_store_id")
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    @Column(name = "kyc_sunrate_bank_id")
    private String kycSunrateBankId;

    /**
     * 询价流水号
     */
    @Column(name = "query_no")
    private String queryNo;

    /**
     * 组织机构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 买入币种
     */
    @Column(name = "buy_cur")
    private String buyCur;

    /**
     * 买入金额
     */
    @Column(name = "buy_amt")
    private BigDecimal buyAmt;

    /**
     * 卖出币种
     */
    @Column(name = "sell_cur")
    private String sellCur;

    /**
     * 卖出金额
     */
    @Column(name = "sell_amt")
    private BigDecimal sellAmt;

    /**
     * 交易模式
     */
    @Column(name = "txn_mode")
    private String txnMode;

    /**
     * 交易金额
     */
    @Column(name = "txn_amt")
    private BigDecimal txnAmt;

    /**
     * 手续费金额
     */
    @Column(name = "fee_amt")
    private BigDecimal feeAmt;

    /**
     * 手续费币种
     */
    @Column(name = "fee_cur")
    private String feeCur;

    /**
     * 支付总金额
     */
    @Column(name = "pay_amt")
    private BigDecimal payAmt;

    /**
     * 询价汇率
     */
    @Column(name = "query_rate")
    private BigDecimal queryRate;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySunrateTradeQueryPrice other = (JsPaySunrateTradeQueryPrice) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKycSunrateStoreId() == null ? other.getKycSunrateStoreId() == null : this.getKycSunrateStoreId().equals(other.getKycSunrateStoreId()))
            && (this.getKycSunrateBankId() == null ? other.getKycSunrateBankId() == null : this.getKycSunrateBankId().equals(other.getKycSunrateBankId()))
            && (this.getQueryNo() == null ? other.getQueryNo() == null : this.getQueryNo().equals(other.getQueryNo()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getBuyCur() == null ? other.getBuyCur() == null : this.getBuyCur().equals(other.getBuyCur()))
            && (this.getBuyAmt() == null ? other.getBuyAmt() == null : this.getBuyAmt().equals(other.getBuyAmt()))
            && (this.getSellCur() == null ? other.getSellCur() == null : this.getSellCur().equals(other.getSellCur()))
            && (this.getSellAmt() == null ? other.getSellAmt() == null : this.getSellAmt().equals(other.getSellAmt()))
            && (this.getTxnMode() == null ? other.getTxnMode() == null : this.getTxnMode().equals(other.getTxnMode()))
            && (this.getTxnAmt() == null ? other.getTxnAmt() == null : this.getTxnAmt().equals(other.getTxnAmt()))
            && (this.getFeeAmt() == null ? other.getFeeAmt() == null : this.getFeeAmt().equals(other.getFeeAmt()))
            && (this.getFeeCur() == null ? other.getFeeCur() == null : this.getFeeCur().equals(other.getFeeCur()))
            && (this.getPayAmt() == null ? other.getPayAmt() == null : this.getPayAmt().equals(other.getPayAmt()))
            && (this.getQueryRate() == null ? other.getQueryRate() == null : this.getQueryRate().equals(other.getQueryRate()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKycSunrateStoreId() == null) ? 0 : getKycSunrateStoreId().hashCode());
        result = prime * result + ((getKycSunrateBankId() == null) ? 0 : getKycSunrateBankId().hashCode());
        result = prime * result + ((getQueryNo() == null) ? 0 : getQueryNo().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getBuyCur() == null) ? 0 : getBuyCur().hashCode());
        result = prime * result + ((getBuyAmt() == null) ? 0 : getBuyAmt().hashCode());
        result = prime * result + ((getSellCur() == null) ? 0 : getSellCur().hashCode());
        result = prime * result + ((getSellAmt() == null) ? 0 : getSellAmt().hashCode());
        result = prime * result + ((getTxnMode() == null) ? 0 : getTxnMode().hashCode());
        result = prime * result + ((getTxnAmt() == null) ? 0 : getTxnAmt().hashCode());
        result = prime * result + ((getFeeAmt() == null) ? 0 : getFeeAmt().hashCode());
        result = prime * result + ((getFeeCur() == null) ? 0 : getFeeCur().hashCode());
        result = prime * result + ((getPayAmt() == null) ? 0 : getPayAmt().hashCode());
        result = prime * result + ((getQueryRate() == null) ? 0 : getQueryRate().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}