package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "china_pnr_batch_detailed_pay")
public class ChinaPNRBatchDetailedPay extends IBaseModel implements Serializable {
    /**
     * 代发交易流水号
     */
    @Column(name = "detailed_id")
    private String detailedId;

    /**
     * 代发批次号
     */
    @Column(name = "batch_no")
    private String batchNo;

    /**
     * 代发金额
     */
    @Column(name = "substitute_amt")
    private BigDecimal substituteAmt;

    /**
     * 代发用途
     */
    private String purpose;

    /**
     * 用户ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 开户号
     */
    @Column(name = "js_open_account_no")
    private String jsOpenAccountNo;

    /**
     * 状态 处理状态010 初始化020已申请040成功030失败
     */
    private String status;

    /**
     * 代发类型 010 贷款服务 020 提现服务 030 汇差 040贷款服务费 050 提现服务费
     */
    @Column(name = "substitute_type")
    private String substituteType;

    /**
     * 错误码
     */
    @Column(name = "error_code")
    private String errorCode;

    /**
     * 错误描述
     */
    @Column(name = "error_msg")
    private String errorMsg;

    /**
     * 请求报文
     */
    @Column(name = "request_message")
    private String requestMessage;

    /**
     * 响应报文
     */
    @Column(name = "response_message")
    private String responseMessage;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ChinaPNRBatchDetailedPay other = (ChinaPNRBatchDetailedPay) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getDetailedId() == null ? other.getDetailedId() == null : this.getDetailedId().equals(other.getDetailedId()))
            && (this.getBatchNo() == null ? other.getBatchNo() == null : this.getBatchNo().equals(other.getBatchNo()))
            && (this.getSubstituteAmt() == null ? other.getSubstituteAmt() == null : this.getSubstituteAmt().equals(other.getSubstituteAmt()))
            && (this.getPurpose() == null ? other.getPurpose() == null : this.getPurpose().equals(other.getPurpose()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getJsOpenAccountNo() == null ? other.getJsOpenAccountNo() == null : this.getJsOpenAccountNo().equals(other.getJsOpenAccountNo()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getSubstituteType() == null ? other.getSubstituteType() == null : this.getSubstituteType().equals(other.getSubstituteType()))
            && (this.getErrorCode() == null ? other.getErrorCode() == null : this.getErrorCode().equals(other.getErrorCode()))
            && (this.getErrorMsg() == null ? other.getErrorMsg() == null : this.getErrorMsg().equals(other.getErrorMsg()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getRequestMessage() == null ? other.getRequestMessage() == null : this.getRequestMessage().equals(other.getRequestMessage()))
            && (this.getResponseMessage() == null ? other.getResponseMessage() == null : this.getResponseMessage().equals(other.getResponseMessage()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getDetailedId() == null) ? 0 : getDetailedId().hashCode());
        result = prime * result + ((getBatchNo() == null) ? 0 : getBatchNo().hashCode());
        result = prime * result + ((getSubstituteAmt() == null) ? 0 : getSubstituteAmt().hashCode());
        result = prime * result + ((getPurpose() == null) ? 0 : getPurpose().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getJsOpenAccountNo() == null) ? 0 : getJsOpenAccountNo().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getSubstituteType() == null) ? 0 : getSubstituteType().hashCode());
        result = prime * result + ((getErrorCode() == null) ? 0 : getErrorCode().hashCode());
        result = prime * result + ((getErrorMsg() == null) ? 0 : getErrorMsg().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getRequestMessage() == null) ? 0 : getRequestMessage().hashCode());
        result = prime * result + ((getResponseMessage() == null) ? 0 : getResponseMessage().hashCode());
        return result;
    }
}