package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;

import com.js.common.enums.BeneficiaryTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "kyc_sunrate_beneficiary")
public class KycSunrateBeneficiary extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 受益人编号-锁汇成交时使用Key，受益人唯一编号
     */
    @Column(name = "beneficiary_id")
    private String beneficiaryId;

    /**
     * 受益人状态-0：审核中,1：审核通过,2：审核未通过 
     */
    @Column(name = "beneficiary_status")
    private String beneficiaryStatus;

    /**
     * 受益人类型-  PLATEFORM_SELF-平台自己
     */
    @Column(name = "beneficiary_type")
    private BeneficiaryTypeEnum beneficiaryType;

    /**
     * 结果通知说明
     */
    @Column(name = "audit_remark")
    private String auditRemark;

    /**
     * 组织机构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 国家代码，受益人国家-如：HK、CN、JP，ISO 3166-1 alpha-2
     */
    @Column(name = "country_code")
    private String countryCode;

    /**
     * 银行名称
     */
    @Column(name = "bank_name")
    private String bankName;

    /**
     * 路由类型，如果 1 和 3 或者 2 和 3 有 2 种方式的话，确认，一个即可 1：aba,2：iban,3：swift 
     */
    @Column(name = "route_type")
    private String routeType;

    /**
     * ABA
     */
    private String aba;

    /**
     * IBAN
     */
    private String iban;

    /**
     * SWIFTCODE
     */
    @Column(name = "swift_code")
    private String swiftcode;

    /**
     * 受益人名称
     */
    @Column(name = "beneficiary_name")
    private String beneficiaryName;

    /**
     * 受益人银行账号，iban 包含账号，此处也需要
     */
    @Column(name = "beneficiary_acct_no")
    private String beneficiaryAcctNo;

    /**
     * 币种
     */
    private String cur;

    /**
     * 受益人地址
     */
    @Column(name = "beneficiary_addr")
    private String beneficiaryAddr;

    /**
     * 备注
     */
    private String remark;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        KycSunrateBeneficiary other = (KycSunrateBeneficiary) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getBeneficiaryId() == null ? other.getBeneficiaryId() == null : this.getBeneficiaryId().equals(other.getBeneficiaryId()))
            && (this.getBeneficiaryStatus() == null ? other.getBeneficiaryStatus() == null : this.getBeneficiaryStatus().equals(other.getBeneficiaryStatus()))
            && (this.getAuditRemark() == null ? other.getAuditRemark() == null : this.getAuditRemark().equals(other.getAuditRemark()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getCountryCode() == null ? other.getCountryCode() == null : this.getCountryCode().equals(other.getCountryCode()))
            && (this.getBankName() == null ? other.getBankName() == null : this.getBankName().equals(other.getBankName()))
            && (this.getRouteType() == null ? other.getRouteType() == null : this.getRouteType().equals(other.getRouteType()))
            && (this.getAba() == null ? other.getAba() == null : this.getAba().equals(other.getAba()))
            && (this.getIban() == null ? other.getIban() == null : this.getIban().equals(other.getIban()))
            && (this.getSwiftcode() == null ? other.getSwiftcode() == null : this.getSwiftcode().equals(other.getSwiftcode()))
            && (this.getBeneficiaryName() == null ? other.getBeneficiaryName() == null : this.getBeneficiaryName().equals(other.getBeneficiaryName()))
            && (this.getBeneficiaryAcctNo() == null ? other.getBeneficiaryAcctNo() == null : this.getBeneficiaryAcctNo().equals(other.getBeneficiaryAcctNo()))
            && (this.getCur() == null ? other.getCur() == null : this.getCur().equals(other.getCur()))
            && (this.getBeneficiaryAddr() == null ? other.getBeneficiaryAddr() == null : this.getBeneficiaryAddr().equals(other.getBeneficiaryAddr()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getBeneficiaryId() == null) ? 0 : getBeneficiaryId().hashCode());
        result = prime * result + ((getBeneficiaryStatus() == null) ? 0 : getBeneficiaryStatus().hashCode());
        result = prime * result + ((getAuditRemark() == null) ? 0 : getAuditRemark().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getCountryCode() == null) ? 0 : getCountryCode().hashCode());
        result = prime * result + ((getBankName() == null) ? 0 : getBankName().hashCode());
        result = prime * result + ((getRouteType() == null) ? 0 : getRouteType().hashCode());
        result = prime * result + ((getAba() == null) ? 0 : getAba().hashCode());
        result = prime * result + ((getIban() == null) ? 0 : getIban().hashCode());
        result = prime * result + ((getSwiftcode() == null) ? 0 : getSwiftcode().hashCode());
        result = prime * result + ((getBeneficiaryName() == null) ? 0 : getBeneficiaryName().hashCode());
        result = prime * result + ((getBeneficiaryAcctNo() == null) ? 0 : getBeneficiaryAcctNo().hashCode());
        result = prime * result + ((getCur() == null) ? 0 : getCur().hashCode());
        result = prime * result + ((getBeneficiaryAddr() == null) ? 0 : getBeneficiaryAddr().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}