package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_sunrate_bank")
public class JsPaySunrateBank extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    @Column(name = "kyc_sunrate_store_id")
    private String kycSunrateStoreId;

    /**
     * 组织机构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 店铺ID
     */
    @Column(name = "sub_acct_no")
    private String subAcctNo;

    /**
     * 收款银行所在地区（地区国家代码，如：HK、CN、JP。ISO 3166-1 alpha-2）
     */
    @Column(name = "bank_country_code")
    private String bankCountryCode;

    /**
     * 收款银行名称
     */
    @Column(name = "bank_name")
    private String bankName;

    /**
     * 收款银行地址
     */
    @Column(name = "bank_addr")
    private String bankAddr;

    /**
     * 收款银行账户名称
     */
    @Column(name = "cus_name")
    private String cusName;

    /**
     * 收款银行账号
     */
    @Column(name = "bank_card_no")
    private String bankCardNo;

    /**
     * 当前余额 = 可用余额 + 冻结金额
     */
    @Column(name = "current_balance")
    private BigDecimal currentBalance;

    /**
     * 可用余额
     */
    @Column(name = "available_balance")
    private BigDecimal availableBalance;

    /**
     * 昨日余额
     */
    @Column(name = "lastday_balance")
    private BigDecimal lastdayBalance;

    /**
     * 冻结余额
     */
    @Column(name = "freezed_balance")
    private BigDecimal freezedBalance;

    /**
     * 币种(如：USD)
     */
    @Column(name = "cur_id")
    private String curId;

    /**
     * 路由方式
     */
    @Column(name = "route_type")
    private String routeType;

    /**
     * aba
     */
    private String aba;

    /**
     * iban
     */
    private String iban;

    /**
     * swiftcode
     */
    @Column(name = "swift_code")
    private String swiftCode;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySunrateBank other = (JsPaySunrateBank) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getSubAcctNo() == null ? other.getSubAcctNo() == null : this.getSubAcctNo().equals(other.getSubAcctNo()))
            && (this.getBankCountryCode() == null ? other.getBankCountryCode() == null : this.getBankCountryCode().equals(other.getBankCountryCode()))
            && (this.getBankName() == null ? other.getBankName() == null : this.getBankName().equals(other.getBankName()))
            && (this.getBankAddr() == null ? other.getBankAddr() == null : this.getBankAddr().equals(other.getBankAddr()))
            && (this.getCusName() == null ? other.getCusName() == null : this.getCusName().equals(other.getCusName()))
            && (this.getBankCardNo() == null ? other.getBankCardNo() == null : this.getBankCardNo().equals(other.getBankCardNo()))
            && (this.getCurId() == null ? other.getCurId() == null : this.getCurId().equals(other.getCurId()))
            && (this.getRouteType() == null ? other.getRouteType() == null : this.getRouteType().equals(other.getRouteType()))
            && (this.getAba() == null ? other.getAba() == null : this.getAba().equals(other.getAba()))
            && (this.getIban() == null ? other.getIban() == null : this.getIban().equals(other.getIban()))
            && (this.getSwiftCode() == null ? other.getSwiftCode() == null : this.getSwiftCode().equals(other.getSwiftCode()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getSubAcctNo() == null) ? 0 : getSubAcctNo().hashCode());
        result = prime * result + ((getBankCountryCode() == null) ? 0 : getBankCountryCode().hashCode());
        result = prime * result + ((getBankName() == null) ? 0 : getBankName().hashCode());
        result = prime * result + ((getBankAddr() == null) ? 0 : getBankAddr().hashCode());
        result = prime * result + ((getCusName() == null) ? 0 : getCusName().hashCode());
        result = prime * result + ((getBankCardNo() == null) ? 0 : getBankCardNo().hashCode());
        result = prime * result + ((getCurId() == null) ? 0 : getCurId().hashCode());
        result = prime * result + ((getRouteType() == null) ? 0 : getRouteType().hashCode());
        result = prime * result + ((getAba() == null) ? 0 : getAba().hashCode());
        result = prime * result + ((getIban() == null) ? 0 : getIban().hashCode());
        result = prime * result + ((getSwiftCode() == null) ? 0 : getSwiftCode().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}