package com.js.dal.dao.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "china_pnr_open_account")
public class ChinaPNROpenAccount extends IBaseModel implements Serializable {
    /**
     * js开户号
     */
    @Column(name = "js_open_account_no")
    private String jsOpenAccountNo;

    /**
     * 用户ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 证件类型
     */
    @Column(name = "cert_type")
    private String certType;

    /**
     * 证件号码
     */
    @Column(name = "cert_id")
    private String certId;

    /**
     * 证件生效日期
     */
    @Column(name = "cert_exp_date_start")
    private String certExpDateStart;

    /**
     * 证件失效日期
     */
    @Column(name = "cert_exp_date_end")
    private String certExpDateEnd;

    /**
     * 手机号
     */
    @Column(name = "mobile_number")
    private String mobileNumber;

    /**
     * 电子邮箱
     */
    private String email;

    /**
     * 开户银行
     */
    @Column(name = "bank_code")
    private String bankCode;

    /**
     * 账户类型 1-对公 2-对私
     */
    @Column(name = "acct_type")
    private String acctType;

    /**
     * 账号
     */
    @Column(name = "bank_acct")
    private String bankAcct;

    /**
     * 户名
     */
    @Column(name = "acct_name")
    private String acctName;

    /**
     * 地址
     */
    private String address;

    /**
     * 汇付开户号
     */
    @Column(name = "china_pnr_open_account_no")
    private String chinaPnrOpenAccountNo;

    /**
     * 状态 0开户成功 1开户失败 2审核中
     */
    private String result;

    /**
     * 开户类型 0个人开户 1 企业开户
     */
    @Column(name = "open_account_type")
    private String openAccountType;

    /**
     * 开户日期
     */
    @Column(name = "open_account_date")
    private Date openAccountDate;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ChinaPNROpenAccount other = (ChinaPNROpenAccount) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getJsOpenAccountNo() == null ? other.getJsOpenAccountNo() == null : this.getJsOpenAccountNo().equals(other.getJsOpenAccountNo()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getCertType() == null ? other.getCertType() == null : this.getCertType().equals(other.getCertType()))
            && (this.getCertId() == null ? other.getCertId() == null : this.getCertId().equals(other.getCertId()))
            && (this.getCertExpDateStart() == null ? other.getCertExpDateStart() == null : this.getCertExpDateStart().equals(other.getCertExpDateStart()))
            && (this.getCertExpDateEnd() == null ? other.getCertExpDateEnd() == null : this.getCertExpDateEnd().equals(other.getCertExpDateEnd()))
            && (this.getMobileNumber() == null ? other.getMobileNumber() == null : this.getMobileNumber().equals(other.getMobileNumber()))
            && (this.getEmail() == null ? other.getEmail() == null : this.getEmail().equals(other.getEmail()))
            && (this.getBankCode() == null ? other.getBankCode() == null : this.getBankCode().equals(other.getBankCode()))
            && (this.getAcctType() == null ? other.getAcctType() == null : this.getAcctType().equals(other.getAcctType()))
            && (this.getBankAcct() == null ? other.getBankAcct() == null : this.getBankAcct().equals(other.getBankAcct()))
            && (this.getAcctName() == null ? other.getAcctName() == null : this.getAcctName().equals(other.getAcctName()))
            && (this.getAddress() == null ? other.getAddress() == null : this.getAddress().equals(other.getAddress()))
            && (this.getChinaPnrOpenAccountNo() == null ? other.getChinaPnrOpenAccountNo() == null : this.getChinaPnrOpenAccountNo().equals(other.getChinaPnrOpenAccountNo()))
            && (this.getResult() == null ? other.getResult() == null : this.getResult().equals(other.getResult()))
            && (this.getOpenAccountType() == null ? other.getOpenAccountType() == null : this.getOpenAccountType().equals(other.getOpenAccountType()))
            && (this.getOpenAccountDate() == null ? other.getOpenAccountDate() == null : this.getOpenAccountDate().equals(other.getOpenAccountDate()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getJsOpenAccountNo() == null) ? 0 : getJsOpenAccountNo().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getCertType() == null) ? 0 : getCertType().hashCode());
        result = prime * result + ((getCertId() == null) ? 0 : getCertId().hashCode());
        result = prime * result + ((getCertExpDateStart() == null) ? 0 : getCertExpDateStart().hashCode());
        result = prime * result + ((getCertExpDateEnd() == null) ? 0 : getCertExpDateEnd().hashCode());
        result = prime * result + ((getMobileNumber() == null) ? 0 : getMobileNumber().hashCode());
        result = prime * result + ((getEmail() == null) ? 0 : getEmail().hashCode());
        result = prime * result + ((getBankCode() == null) ? 0 : getBankCode().hashCode());
        result = prime * result + ((getAcctType() == null) ? 0 : getAcctType().hashCode());
        result = prime * result + ((getBankAcct() == null) ? 0 : getBankAcct().hashCode());
        result = prime * result + ((getAcctName() == null) ? 0 : getAcctName().hashCode());
        result = prime * result + ((getAddress() == null) ? 0 : getAddress().hashCode());
        result = prime * result + ((getChinaPnrOpenAccountNo() == null) ? 0 : getChinaPnrOpenAccountNo().hashCode());
        result = prime * result + ((getResult() == null) ? 0 : getResult().hashCode());
        result = prime * result + ((getOpenAccountType() == null) ? 0 : getOpenAccountType().hashCode());
        result = prime * result + ((getOpenAccountDate() == null) ? 0 : getOpenAccountDate().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}