package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import com.js.common.enums.SiteEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "kyc_sunrate_store")
public class KycSunrateStore extends IBaseModel implements Serializable {
    /**
     * 注册表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 店铺表主键ID
     */
    @Column(name = "kyc_store_id")
    private String kycStoreId;

    /**
     * 组织机构代码-识别客户
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 店铺所在站点（美国站 USD，日本站 JPY，欧洲站 EUR，英国站 GB）
     */
    @Column(name = "cur_id")
    private String curId;
    
    @Column(name = "store_the_site")
    private SiteEnum storeTheSite;

    /**
     * 店铺名称
     */
    @Column(name = "store_name")
    private String storeName;

    /**
     * 店铺网址
     */
    @Column(name = "store_url")
    private String storeUrl;

    /**
     * 店铺平台（01 amazon ，02 ebay ，03 yahoo，04 fril  ，05 mercari ）
     */
    @Column(name = "store_plateform")
    private String storePlateform;

    /**
     * 卖家ID
     */
    @Column(name = "seller_id")
    private String sellerId;

    /**
     * AWS 访问 Key(AKIAJJSMHVJAFRKNERIA)
     */
    @Column(name = "access_key")
    private String accessKey;

    /**
     * 私有秘钥（3ZvKcmoEQLDfE9AUX8MRsPGfOzc6m5CGlBnEqhPg）
     */
    @Column(name = "secret_key")
    private String secretKey;

    /**
     * 销售商品
     */
    @Column(name = "sell_goods")
    private String sellGoods;

    /**
     * 运营时间
     */
    @Column(name = "run_time")
    private Date runTime;

    /**
     * 预估月收款总额-单位（万美元）
     */
    @Column(name = "month_amt")
    private BigDecimal monthAmt;

    /**
     * 店铺ID
     */
    @Column(name = "sub_acct_no")
    private String subAcctNo;

    /**
     * 审核结果（1-审核通过，2-审核未通过）
     */
    @Column(name = "audit_status")
    private Integer auditStatus;

    /**
     * 审核备注
     */
    @Column(name = "audit_remark")
    private String auditRemark;

    /**
     * 完成审核时间
     */
    @Column(name = "audit_dts")
    private Date auditDts;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        KycSunrateStore other = (KycSunrateStore) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKycStoreId() == null ? other.getKycStoreId() == null : this.getKycStoreId().equals(other.getKycStoreId()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getCurId() == null ? other.getCurId() == null : this.getCurId().equals(other.getCurId()))
            && (this.getStoreName() == null ? other.getStoreName() == null : this.getStoreName().equals(other.getStoreName()))
            && (this.getStoreUrl() == null ? other.getStoreUrl() == null : this.getStoreUrl().equals(other.getStoreUrl()))
            && (this.getStorePlateform() == null ? other.getStorePlateform() == null : this.getStorePlateform().equals(other.getStorePlateform()))
            && (this.getSellerId() == null ? other.getSellerId() == null : this.getSellerId().equals(other.getSellerId()))
            && (this.getAccessKey() == null ? other.getAccessKey() == null : this.getAccessKey().equals(other.getAccessKey()))
            && (this.getSecretKey() == null ? other.getSecretKey() == null : this.getSecretKey().equals(other.getSecretKey()))
            && (this.getSellGoods() == null ? other.getSellGoods() == null : this.getSellGoods().equals(other.getSellGoods()))
            && (this.getRunTime() == null ? other.getRunTime() == null : this.getRunTime().equals(other.getRunTime()))
            && (this.getMonthAmt() == null ? other.getMonthAmt() == null : this.getMonthAmt().equals(other.getMonthAmt()))
            && (this.getSubAcctNo() == null ? other.getSubAcctNo() == null : this.getSubAcctNo().equals(other.getSubAcctNo()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getAuditStatus() == null ? other.getAuditStatus() == null : this.getAuditStatus().equals(other.getAuditStatus()))
            && (this.getAuditRemark() == null ? other.getAuditRemark() == null : this.getAuditRemark().equals(other.getAuditRemark()))
            && (this.getAuditDts() == null ? other.getAuditDts() == null : this.getAuditDts().equals(other.getAuditDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKycStoreId() == null) ? 0 : getKycStoreId().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getCurId() == null) ? 0 : getCurId().hashCode());
        result = prime * result + ((getStoreName() == null) ? 0 : getStoreName().hashCode());
        result = prime * result + ((getStoreUrl() == null) ? 0 : getStoreUrl().hashCode());
        result = prime * result + ((getStorePlateform() == null) ? 0 : getStorePlateform().hashCode());
        result = prime * result + ((getSellerId() == null) ? 0 : getSellerId().hashCode());
        result = prime * result + ((getAccessKey() == null) ? 0 : getAccessKey().hashCode());
        result = prime * result + ((getSecretKey() == null) ? 0 : getSecretKey().hashCode());
        result = prime * result + ((getSellGoods() == null) ? 0 : getSellGoods().hashCode());
        result = prime * result + ((getRunTime() == null) ? 0 : getRunTime().hashCode());
        result = prime * result + ((getMonthAmt() == null) ? 0 : getMonthAmt().hashCode());
        result = prime * result + ((getSubAcctNo() == null) ? 0 : getSubAcctNo().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getAuditStatus() == null) ? 0 : getAuditStatus().hashCode());
        result = prime * result + ((getAuditRemark() == null) ? 0 : getAuditRemark().hashCode());
        result = prime * result + ((getAuditDts() == null) ? 0 : getAuditDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}