package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_sync_amazon_order_item")
public class JsSyncAmazonOrderItem extends IBaseModel implements Serializable {
    /**
     * 用户 id
     */
    @Column(name = "user_natural_id")
    private String userNaturalId;

    /**
     * 订单 id
     */
    @Column(name = "order_id")
    private String orderId;

    /**
     * 店铺 id
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 亚马逊标准唯一认证识别号
     */
    private String asin;

    /**
     * 卖家商品 sku
     */
    private String sellersku;

    /**
     * 商品明细 id
     */
    @Column(name = "order_item_id")
    private String orderItemId;

    /**
     * 商品名称
     */
    private String title;

    /**
     * 订单商品数量
     */
    @Column(name = "quantity_ordered")
    private BigDecimal quantityOrdered;

    /**
     * 订单商品已经发货的数量
     */
    @Column(name = "quantity_shipped")
    private BigDecimal quantityShipped;

    /**
     * 商品价格币种
     */
    @Column(name = "item_price_code")
    private String itemPriceCode;

    /**
     * 商品总价格。等于商品价格乘以商品数量，不包含运费与包装费
     */
    @Column(name = "item_price")
    private BigDecimal itemPrice;

    /**
     * 运费币种
     */
    @Column(name = "shipping_price_code")
    private String shippingPriceCode;

    /**
     * 运费
     */
    @Column(name = "shipping_price")
    private BigDecimal shippingPrice;

    /**
     * 包装费币种
     */
    @Column(name = "gift_wrap_price_code")
    private String giftWrapPriceCode;

    /**
     * 包装费
     */
    @Column(name = "gift_wrap_price")
    private BigDecimal giftWrapPrice;

    /**
     * 商品税费币种
     */
    @Column(name = "item_tax_code")
    private String itemTaxCode;

    /**
     * 商品税费
     */
    @Column(name = "item_tax")
    private BigDecimal itemTax;

    /**
     * 运费税币种
     */
    @Column(name = "shipping_tax_code")
    private String shippingTaxCode;

    /**
     * 运费税
     */
    @Column(name = "shipping_tax")
    private BigDecimal shippingTax;

    /**
     * 运费税币种
     */
    @Column(name = "gift_wrap_tax_code")
    private String giftWrapTaxCode;

    /**
     * 运费税
     */
    @Column(name = "gift_wrap_tax")
    private BigDecimal giftWrapTax;

    /**
     * 运费折扣币种
     */
    @Column(name = "shipping_discount_code")
    private String shippingDiscountCode;

    /**
     * 运费折扣
     */
    @Column(name = "shipping_discount")
    private BigDecimal shippingDiscount;

    /**
     * 运费折扣税币种
     */
    @Column(name = "shipping_discount_tax_code")
    private String shippingDiscountTaxCode;

    /**
     * 运费折扣税
     */
    @Column(name = "shipping_discount_tax")
    private BigDecimal shippingDiscountTax;

    /**
     * 促销折扣币种
     */
    @Column(name = "promotion_discount_code")
    private String promotionDiscountCode;

    /**
     * 促销折扣
     */
    @Column(name = "promotion_discount")
    private BigDecimal promotionDiscount;

    /**
     * 促销折扣税币种
     */
    @Column(name = "promotion_discount_tax_code")
    private String promotionDiscountTaxCode;

    /**
     * 促销折扣税
     */
    @Column(name = "promotion_discount_tax")
    private BigDecimal promotionDiscountTax;

    /**
     * cod费用币种
     */
    @Column(name = "cod_fee_code")
    private String codFeeCode;

    /**
     * cod费用
     */
    @Column(name = "cod_fee")
    private BigDecimal codFee;

    /**
     * cod费用折扣币种
     */
    @Column(name = "cod_fee_discount_code")
    private String codFeeDiscountCode;

    /**
     * cod费用折扣
     */
    @Column(name = "cod_fee_discount")
    private BigDecimal codFeeDiscount;

    /**
     * 是否是礼品
     */
    @Column(name = "is_gift")
    private Boolean isGift;

    /**
     * 礼品包装说明文字
     */
    @Column(name = "gift_message_text")
    private String giftMessageText;

    /**
     * 礼品包装等级
     */
    @Column(name = "gift_wrap_level")
    private String giftWrapLevel;

    /**
     * 卖家描述的商状态
     */
    @Column(name = "condition_note")
    private String conditionNote;

    /**
     * 商品状态
     */
    @Column(name = "condition_id")
    private String conditionId;

    /**
     * 商品子状态
     */
    @Column(name = "condition_subtype_id")
    private String conditionSubtypeId;

    /**
     * 指定价格，对商业订单才有效
     */
    @Column(name = "price_designation")
    private String priceDesignation;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsSyncAmazonOrderItem other = (JsSyncAmazonOrderItem) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getUserNaturalId() == null ? other.getUserNaturalId() == null : this.getUserNaturalId().equals(other.getUserNaturalId()))
            && (this.getOrderId() == null ? other.getOrderId() == null : this.getOrderId().equals(other.getOrderId()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getAsin() == null ? other.getAsin() == null : this.getAsin().equals(other.getAsin()))
            && (this.getSellersku() == null ? other.getSellersku() == null : this.getSellersku().equals(other.getSellersku()))
            && (this.getOrderItemId() == null ? other.getOrderItemId() == null : this.getOrderItemId().equals(other.getOrderItemId()))
            && (this.getTitle() == null ? other.getTitle() == null : this.getTitle().equals(other.getTitle()))
            && (this.getQuantityOrdered() == null ? other.getQuantityOrdered() == null : this.getQuantityOrdered().equals(other.getQuantityOrdered()))
            && (this.getQuantityShipped() == null ? other.getQuantityShipped() == null : this.getQuantityShipped().equals(other.getQuantityShipped()))
            && (this.getItemPriceCode() == null ? other.getItemPriceCode() == null : this.getItemPriceCode().equals(other.getItemPriceCode()))
            && (this.getItemPrice() == null ? other.getItemPrice() == null : this.getItemPrice().equals(other.getItemPrice()))
            && (this.getShippingPriceCode() == null ? other.getShippingPriceCode() == null : this.getShippingPriceCode().equals(other.getShippingPriceCode()))
            && (this.getShippingPrice() == null ? other.getShippingPrice() == null : this.getShippingPrice().equals(other.getShippingPrice()))
            && (this.getGiftWrapPriceCode() == null ? other.getGiftWrapPriceCode() == null : this.getGiftWrapPriceCode().equals(other.getGiftWrapPriceCode()))
            && (this.getGiftWrapPrice() == null ? other.getGiftWrapPrice() == null : this.getGiftWrapPrice().equals(other.getGiftWrapPrice()))
            && (this.getItemTaxCode() == null ? other.getItemTaxCode() == null : this.getItemTaxCode().equals(other.getItemTaxCode()))
            && (this.getItemTax() == null ? other.getItemTax() == null : this.getItemTax().equals(other.getItemTax()))
            && (this.getShippingTaxCode() == null ? other.getShippingTaxCode() == null : this.getShippingTaxCode().equals(other.getShippingTaxCode()))
            && (this.getShippingTax() == null ? other.getShippingTax() == null : this.getShippingTax().equals(other.getShippingTax()))
            && (this.getGiftWrapTaxCode() == null ? other.getGiftWrapTaxCode() == null : this.getGiftWrapTaxCode().equals(other.getGiftWrapTaxCode()))
            && (this.getGiftWrapTax() == null ? other.getGiftWrapTax() == null : this.getGiftWrapTax().equals(other.getGiftWrapTax()))
            && (this.getShippingDiscountCode() == null ? other.getShippingDiscountCode() == null : this.getShippingDiscountCode().equals(other.getShippingDiscountCode()))
            && (this.getShippingDiscount() == null ? other.getShippingDiscount() == null : this.getShippingDiscount().equals(other.getShippingDiscount()))
            && (this.getShippingDiscountTaxCode() == null ? other.getShippingDiscountTaxCode() == null : this.getShippingDiscountTaxCode().equals(other.getShippingDiscountTaxCode()))
            && (this.getShippingDiscountTax() == null ? other.getShippingDiscountTax() == null : this.getShippingDiscountTax().equals(other.getShippingDiscountTax()))
            && (this.getPromotionDiscountCode() == null ? other.getPromotionDiscountCode() == null : this.getPromotionDiscountCode().equals(other.getPromotionDiscountCode()))
            && (this.getPromotionDiscount() == null ? other.getPromotionDiscount() == null : this.getPromotionDiscount().equals(other.getPromotionDiscount()))
            && (this.getPromotionDiscountTaxCode() == null ? other.getPromotionDiscountTaxCode() == null : this.getPromotionDiscountTaxCode().equals(other.getPromotionDiscountTaxCode()))
            && (this.getPromotionDiscountTax() == null ? other.getPromotionDiscountTax() == null : this.getPromotionDiscountTax().equals(other.getPromotionDiscountTax()))
            && (this.getCodFeeCode() == null ? other.getCodFeeCode() == null : this.getCodFeeCode().equals(other.getCodFeeCode()))
            && (this.getCodFee() == null ? other.getCodFee() == null : this.getCodFee().equals(other.getCodFee()))
            && (this.getCodFeeDiscountCode() == null ? other.getCodFeeDiscountCode() == null : this.getCodFeeDiscountCode().equals(other.getCodFeeDiscountCode()))
            && (this.getCodFeeDiscount() == null ? other.getCodFeeDiscount() == null : this.getCodFeeDiscount().equals(other.getCodFeeDiscount()))
            && (this.getIsGift() == null ? other.getIsGift() == null : this.getIsGift().equals(other.getIsGift()))
            && (this.getGiftMessageText() == null ? other.getGiftMessageText() == null : this.getGiftMessageText().equals(other.getGiftMessageText()))
            && (this.getGiftWrapLevel() == null ? other.getGiftWrapLevel() == null : this.getGiftWrapLevel().equals(other.getGiftWrapLevel()))
            && (this.getConditionNote() == null ? other.getConditionNote() == null : this.getConditionNote().equals(other.getConditionNote()))
            && (this.getConditionId() == null ? other.getConditionId() == null : this.getConditionId().equals(other.getConditionId()))
            && (this.getConditionSubtypeId() == null ? other.getConditionSubtypeId() == null : this.getConditionSubtypeId().equals(other.getConditionSubtypeId()))
            && (this.getPriceDesignation() == null ? other.getPriceDesignation() == null : this.getPriceDesignation().equals(other.getPriceDesignation()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getUserNaturalId() == null) ? 0 : getUserNaturalId().hashCode());
        result = prime * result + ((getOrderId() == null) ? 0 : getOrderId().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getAsin() == null) ? 0 : getAsin().hashCode());
        result = prime * result + ((getSellersku() == null) ? 0 : getSellersku().hashCode());
        result = prime * result + ((getOrderItemId() == null) ? 0 : getOrderItemId().hashCode());
        result = prime * result + ((getTitle() == null) ? 0 : getTitle().hashCode());
        result = prime * result + ((getQuantityOrdered() == null) ? 0 : getQuantityOrdered().hashCode());
        result = prime * result + ((getQuantityShipped() == null) ? 0 : getQuantityShipped().hashCode());
        result = prime * result + ((getItemPriceCode() == null) ? 0 : getItemPriceCode().hashCode());
        result = prime * result + ((getItemPrice() == null) ? 0 : getItemPrice().hashCode());
        result = prime * result + ((getShippingPriceCode() == null) ? 0 : getShippingPriceCode().hashCode());
        result = prime * result + ((getShippingPrice() == null) ? 0 : getShippingPrice().hashCode());
        result = prime * result + ((getGiftWrapPriceCode() == null) ? 0 : getGiftWrapPriceCode().hashCode());
        result = prime * result + ((getGiftWrapPrice() == null) ? 0 : getGiftWrapPrice().hashCode());
        result = prime * result + ((getItemTaxCode() == null) ? 0 : getItemTaxCode().hashCode());
        result = prime * result + ((getItemTax() == null) ? 0 : getItemTax().hashCode());
        result = prime * result + ((getShippingTaxCode() == null) ? 0 : getShippingTaxCode().hashCode());
        result = prime * result + ((getShippingTax() == null) ? 0 : getShippingTax().hashCode());
        result = prime * result + ((getGiftWrapTaxCode() == null) ? 0 : getGiftWrapTaxCode().hashCode());
        result = prime * result + ((getGiftWrapTax() == null) ? 0 : getGiftWrapTax().hashCode());
        result = prime * result + ((getShippingDiscountCode() == null) ? 0 : getShippingDiscountCode().hashCode());
        result = prime * result + ((getShippingDiscount() == null) ? 0 : getShippingDiscount().hashCode());
        result = prime * result + ((getShippingDiscountTaxCode() == null) ? 0 : getShippingDiscountTaxCode().hashCode());
        result = prime * result + ((getShippingDiscountTax() == null) ? 0 : getShippingDiscountTax().hashCode());
        result = prime * result + ((getPromotionDiscountCode() == null) ? 0 : getPromotionDiscountCode().hashCode());
        result = prime * result + ((getPromotionDiscount() == null) ? 0 : getPromotionDiscount().hashCode());
        result = prime * result + ((getPromotionDiscountTaxCode() == null) ? 0 : getPromotionDiscountTaxCode().hashCode());
        result = prime * result + ((getPromotionDiscountTax() == null) ? 0 : getPromotionDiscountTax().hashCode());
        result = prime * result + ((getCodFeeCode() == null) ? 0 : getCodFeeCode().hashCode());
        result = prime * result + ((getCodFee() == null) ? 0 : getCodFee().hashCode());
        result = prime * result + ((getCodFeeDiscountCode() == null) ? 0 : getCodFeeDiscountCode().hashCode());
        result = prime * result + ((getCodFeeDiscount() == null) ? 0 : getCodFeeDiscount().hashCode());
        result = prime * result + ((getIsGift() == null) ? 0 : getIsGift().hashCode());
        result = prime * result + ((getGiftMessageText() == null) ? 0 : getGiftMessageText().hashCode());
        result = prime * result + ((getGiftWrapLevel() == null) ? 0 : getGiftWrapLevel().hashCode());
        result = prime * result + ((getConditionNote() == null) ? 0 : getConditionNote().hashCode());
        result = prime * result + ((getConditionId() == null) ? 0 : getConditionId().hashCode());
        result = prime * result + ((getConditionSubtypeId() == null) ? 0 : getConditionSubtypeId().hashCode());
        result = prime * result + ((getPriceDesignation() == null) ? 0 : getPriceDesignation().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}