package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "china_pnr_batch_pay")
public class ChinaPNRBatchPay extends IBaseModel implements Serializable {
    /**
     * 代发批次号
     */
    @Column(name = "batch_no")
    private String batchNo;

    /**
     * 汇付请求流水号
     */
    @Column(name = "request_id")
    private String requestId;

    /**
     * 请求时间
     */
    @Column(name = "request_time")
    private Date requestTime;

    /**
     * 付款币种 默认CNY
     */
    @Column(name = "pay_cur")
    private String payCur;

    /**
     * 总笔数
     */
    @Column(name = "pay_cnt")
    private Integer payCnt;

    /**
     * 总金额
     */
    @Column(name = "pay_amt")
    private BigDecimal payAmt;

    /**
     * 到账类型1：T+0到账2：T+1到账
            
     */
    @Column(name = "remit_type")
    private String remitType;

    /**
     * 是否忽略错误行 1：不忽略 2：忽略
     */
    @Column(name = "ignore_flag")
    private String ignoreFlag;

    /**
     * 用途
     */
    private String purpose;

    /**
     * 结果通知地址
     */
    @Column(name = "notice_url")
    private String noticeUrl;

    /**
     * 实时结果通知地址
     */
    @Column(name = "real_time_notice_url")
    private String realTimeNoticeUrl;

    /**
     * 接收状态1:全部接收成功 2:全部接收失败3:部分接收成功（当ignoreFlag=2时返回）
            
     */
    @Column(name = "receive_status")
    private String receiveStatus;

    /**
     * 处理状态010 初始化020已申请040回调成功030失败
     */
    @Column(name = "handle_status")
    private String handleStatus;

    /**
     * 错误码
     */
    @Column(name = "error_code")
    private String errorCode;

    /**
     * 错误描述
     */
    @Column(name = "error_msg")
    private String errorMsg;

    /**
     * 请求报文
     */
    @Column(name = "request_message")
    private String requestMessage;

    /**
     * 响应报文
     */
    @Column(name = "response_message")
    private String responseMessage;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ChinaPNRBatchPay other = (ChinaPNRBatchPay) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getBatchNo() == null ? other.getBatchNo() == null : this.getBatchNo().equals(other.getBatchNo()))
            && (this.getRequestId() == null ? other.getRequestId() == null : this.getRequestId().equals(other.getRequestId()))
            && (this.getRequestTime() == null ? other.getRequestTime() == null : this.getRequestTime().equals(other.getRequestTime()))
            && (this.getPayCur() == null ? other.getPayCur() == null : this.getPayCur().equals(other.getPayCur()))
            && (this.getPayCnt() == null ? other.getPayCnt() == null : this.getPayCnt().equals(other.getPayCnt()))
            && (this.getPayAmt() == null ? other.getPayAmt() == null : this.getPayAmt().equals(other.getPayAmt()))
            && (this.getRemitType() == null ? other.getRemitType() == null : this.getRemitType().equals(other.getRemitType()))
            && (this.getIgnoreFlag() == null ? other.getIgnoreFlag() == null : this.getIgnoreFlag().equals(other.getIgnoreFlag()))
            && (this.getPurpose() == null ? other.getPurpose() == null : this.getPurpose().equals(other.getPurpose()))
            && (this.getNoticeUrl() == null ? other.getNoticeUrl() == null : this.getNoticeUrl().equals(other.getNoticeUrl()))
            && (this.getRealTimeNoticeUrl() == null ? other.getRealTimeNoticeUrl() == null : this.getRealTimeNoticeUrl().equals(other.getRealTimeNoticeUrl()))
            && (this.getReceiveStatus() == null ? other.getReceiveStatus() == null : this.getReceiveStatus().equals(other.getReceiveStatus()))
            && (this.getHandleStatus() == null ? other.getHandleStatus() == null : this.getHandleStatus().equals(other.getHandleStatus()))
            && (this.getErrorCode() == null ? other.getErrorCode() == null : this.getErrorCode().equals(other.getErrorCode()))
            && (this.getErrorMsg() == null ? other.getErrorMsg() == null : this.getErrorMsg().equals(other.getErrorMsg()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getRequestMessage() == null ? other.getRequestMessage() == null : this.getRequestMessage().equals(other.getRequestMessage()))
            && (this.getResponseMessage() == null ? other.getResponseMessage() == null : this.getResponseMessage().equals(other.getResponseMessage()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getBatchNo() == null) ? 0 : getBatchNo().hashCode());
        result = prime * result + ((getRequestId() == null) ? 0 : getRequestId().hashCode());
        result = prime * result + ((getRequestTime() == null) ? 0 : getRequestTime().hashCode());
        result = prime * result + ((getPayCur() == null) ? 0 : getPayCur().hashCode());
        result = prime * result + ((getPayCnt() == null) ? 0 : getPayCnt().hashCode());
        result = prime * result + ((getPayAmt() == null) ? 0 : getPayAmt().hashCode());
        result = prime * result + ((getRemitType() == null) ? 0 : getRemitType().hashCode());
        result = prime * result + ((getIgnoreFlag() == null) ? 0 : getIgnoreFlag().hashCode());
        result = prime * result + ((getPurpose() == null) ? 0 : getPurpose().hashCode());
        result = prime * result + ((getNoticeUrl() == null) ? 0 : getNoticeUrl().hashCode());
        result = prime * result + ((getRealTimeNoticeUrl() == null) ? 0 : getRealTimeNoticeUrl().hashCode());
        result = prime * result + ((getReceiveStatus() == null) ? 0 : getReceiveStatus().hashCode());
        result = prime * result + ((getHandleStatus() == null) ? 0 : getHandleStatus().hashCode());
        result = prime * result + ((getErrorCode() == null) ? 0 : getErrorCode().hashCode());
        result = prime * result + ((getErrorMsg() == null) ? 0 : getErrorMsg().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getRequestMessage() == null) ? 0 : getRequestMessage().hashCode());
        result = prime * result + ((getResponseMessage() == null) ? 0 : getResponseMessage().hashCode());
        return result;
    }
}