package com.js.dal.dao.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "qichacha_enterprise_info")
public class QiChaChaEnterpriseInfo extends IBaseModel implements Serializable {
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 根据此字段获取详细信息
     */
    @Column(name = "key_no")
    private String keyNo;

    /**
     * 公司名称
     */
    private String name;

    /**
     * 注册号
     */
    private String no;

    /**
     * 成立日期
     */
    @Column(name = "start_date")
    private Date startDate;

    /**
     * 信用代码
     */
    @Column(name = "credit_code")
    private String creditCode;

    /**
     * 请求时间
     */
    @Column(name = "reqest_time")
    private Date reqestTime;

    /**
     * 公司所在省
     */
    private String province;

    /**
     * 公司所在市
     */
    private String city;

    /**
     * 持股50%以上的股东
     */
    private String partner50;

    /**
     * 法人是否是股东
     */
    @Column(name = "oper_is_partner")
    private Boolean operIsPartner;

    /**
     * 企业近一年法人有无变更
     */
    @Column(name = "oper_change")
    private Boolean operChange;

    /**
     * 企业近一年股东有无变更
     */
    @Column(name = "partner_change")
    private Boolean partnerChange;

    /**
     * 近一年借款企业和关联企业命中法院执行或涉诉
     */
    @Column(name = "has_execution")
    private Boolean hasExecution;

    /**
     * 近一年借款企业和关联企业命中行政处罚
     */
    @Column(name = "has_penalty")
    private Boolean hasPenalty;

    /**
     * 近一年借款企业和关联企业命中经营地异常信息
     */
    @Column(name = "has_exception")
    private Boolean hasException;

    /**
     * 响应报文
     */
    @Column(name = "response_body_data")
    private String responseBodyData;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        QiChaChaEnterpriseInfo other = (QiChaChaEnterpriseInfo) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKeyNo() == null ? other.getKeyNo() == null : this.getKeyNo().equals(other.getKeyNo()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getNo() == null ? other.getNo() == null : this.getNo().equals(other.getNo()))
            && (this.getStartDate() == null ? other.getStartDate() == null : this.getStartDate().equals(other.getStartDate()))
            && (this.getCreditCode() == null ? other.getCreditCode() == null : this.getCreditCode().equals(other.getCreditCode()))
            && (this.getReqestTime() == null ? other.getReqestTime() == null : this.getReqestTime().equals(other.getReqestTime()))
            && (this.getProvince() == null ? other.getProvince() == null : this.getProvince().equals(other.getProvince()))
            && (this.getCity() == null ? other.getCity() == null : this.getCity().equals(other.getCity()))
            && (this.getPartner50() == null ? other.getPartner50() == null : this.getPartner50().equals(other.getPartner50()))
            && (this.getOperIsPartner() == null ? other.getOperIsPartner() == null : this.getOperIsPartner().equals(other.getOperIsPartner()))
            && (this.getOperChange() == null ? other.getOperChange() == null : this.getOperChange().equals(other.getOperChange()))
            && (this.getPartnerChange() == null ? other.getPartnerChange() == null : this.getPartnerChange().equals(other.getPartnerChange()))
            && (this.getHasExecution() == null ? other.getHasExecution() == null : this.getHasExecution().equals(other.getHasExecution()))
            && (this.getHasPenalty() == null ? other.getHasPenalty() == null : this.getHasPenalty().equals(other.getHasPenalty()))
            && (this.getHasException() == null ? other.getHasException() == null : this.getHasException().equals(other.getHasException()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getResponseBodyData() == null ? other.getResponseBodyData() == null : this.getResponseBodyData().equals(other.getResponseBodyData()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKeyNo() == null) ? 0 : getKeyNo().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getNo() == null) ? 0 : getNo().hashCode());
        result = prime * result + ((getStartDate() == null) ? 0 : getStartDate().hashCode());
        result = prime * result + ((getCreditCode() == null) ? 0 : getCreditCode().hashCode());
        result = prime * result + ((getReqestTime() == null) ? 0 : getReqestTime().hashCode());
        result = prime * result + ((getProvince() == null) ? 0 : getProvince().hashCode());
        result = prime * result + ((getCity() == null) ? 0 : getCity().hashCode());
        result = prime * result + ((getPartner50() == null) ? 0 : getPartner50().hashCode());
        result = prime * result + ((getOperIsPartner() == null) ? 0 : getOperIsPartner().hashCode());
        result = prime * result + ((getOperChange() == null) ? 0 : getOperChange().hashCode());
        result = prime * result + ((getPartnerChange() == null) ? 0 : getPartnerChange().hashCode());
        result = prime * result + ((getHasExecution() == null) ? 0 : getHasExecution().hashCode());
        result = prime * result + ((getHasPenalty() == null) ? 0 : getHasPenalty().hashCode());
        result = prime * result + ((getHasException() == null) ? 0 : getHasException().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getResponseBodyData() == null) ? 0 : getResponseBodyData().hashCode());
        return result;
    }
}