package com.js.dal.dao.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "kyc_certi_mainland_personal")
public class KycCertiMainLandPersonal extends IBaseModel implements Serializable {
    /**
     * 注册表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 证件类型（1-第二代身份证）
     */
    @Column(name = "id_type")
    private String idType;

    /**
     * 证件类型名称（1-第二代身份证）
     */
    @Column(name = "id_type_name")
    private String idTypeName;

    /**
     * 客户真实姓名
     */
    @Column(name = "cus_name")
    private String cusName;

    /**
     * 客户英文名称
     */
    @Column(name = "cus_eng_name")
    private String cusEngName;

    /**
     * 身份证号
     */
    @Column(name = "id_no")
    private String idNo;

    /**
     * 身份证有效起始日期
     */
    @Column(name = "effective_start_time")
    private Date effectiveStartTime;

    /**
     * 身份证有效截止日期
     */
    @Column(name = "effective_end_time")
    private Date effectiveEndTime;

    /**
     * 是否长期有效(0:非长期，1：长期)
     */
    @Column(name = "long_flag")
    private Boolean longFlag;

    /**
     * 店铺主要经营类别表ID
     */
    @Column(name = "store_business_type_id")
    private String storeBusinessTypeId;

    /**
     * 店铺主要经营类别名称
     */
    @Column(name = "store_business_type_name")
    private String storeBusinessTypeName;

    /**
     * 个人住址
     */
    @Column(name = "live_address")
    private String liveAddress;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        KycCertiMainLandPersonal other = (KycCertiMainLandPersonal) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getIdType() == null ? other.getIdType() == null : this.getIdType().equals(other.getIdType()))
            && (this.getIdTypeName() == null ? other.getIdTypeName() == null : this.getIdTypeName().equals(other.getIdTypeName()))
            && (this.getCusName() == null ? other.getCusName() == null : this.getCusName().equals(other.getCusName()))
            && (this.getCusEngName() == null ? other.getCusEngName() == null : this.getCusEngName().equals(other.getCusEngName()))
            && (this.getIdNo() == null ? other.getIdNo() == null : this.getIdNo().equals(other.getIdNo()))
            && (this.getEffectiveStartTime() == null ? other.getEffectiveStartTime() == null : this.getEffectiveStartTime().equals(other.getEffectiveStartTime()))
            && (this.getEffectiveEndTime() == null ? other.getEffectiveEndTime() == null : this.getEffectiveEndTime().equals(other.getEffectiveEndTime()))
            && (this.getLongFlag() == null ? other.getLongFlag() == null : this.getLongFlag().equals(other.getLongFlag()))
            && (this.getStoreBusinessTypeId() == null ? other.getStoreBusinessTypeId() == null : this.getStoreBusinessTypeId().equals(other.getStoreBusinessTypeId()))
            && (this.getStoreBusinessTypeName() == null ? other.getStoreBusinessTypeName() == null : this.getStoreBusinessTypeName().equals(other.getStoreBusinessTypeName()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getLiveAddress() == null ? other.getLiveAddress() == null : this.getLiveAddress().equals(other.getLiveAddress()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getIdType() == null) ? 0 : getIdType().hashCode());
        result = prime * result + ((getIdTypeName() == null) ? 0 : getIdTypeName().hashCode());
        result = prime * result + ((getCusName() == null) ? 0 : getCusName().hashCode());
        result = prime * result + ((getCusEngName() == null) ? 0 : getCusEngName().hashCode());
        result = prime * result + ((getIdNo() == null) ? 0 : getIdNo().hashCode());
        result = prime * result + ((getEffectiveStartTime() == null) ? 0 : getEffectiveStartTime().hashCode());
        result = prime * result + ((getEffectiveEndTime() == null) ? 0 : getEffectiveEndTime().hashCode());
        result = prime * result + ((getLongFlag() == null) ? 0 : getLongFlag().hashCode());
        result = prime * result + ((getStoreBusinessTypeId() == null) ? 0 : getStoreBusinessTypeId().hashCode());
        result = prime * result + ((getStoreBusinessTypeName() == null) ? 0 : getStoreBusinessTypeName().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getLiveAddress() == null) ? 0 : getLiveAddress().hashCode());
        return result;
    }
}