package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_trade")
public class JsTrade extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 外部交易单号
     */
    @Column(name = "trade_no")
    private String tradeNo;

    /**
     * 账户类型 1.寻汇，2.汇付
     */
    @Column(name = "acc_type")
    private String accType;

    /**
     * 交易类型[0:账户入账,1:账户出账]
     */
    @Column(name = "trade_type")
    private String tradeType;

    /**
     * 入账账户号
     */
    @Column(name = "in_acct")
    private String inAcct;

    /**
     * 入账账户名称
     */
    @Column(name = "in_acct_name")
    private String inAcctName;

    /**
     * 出账账户号
     */
    @Column(name = "out_acct")
    private String outAcct;

    /**
     * 出账账户名称
     */
    @Column(name = "out_acct_name")
    private String outAcctName;

    /**
     * 交易子类型[0:子账户入账,1:还款,2:提现,3:提现手续费,4:逾期费,5:vat,6:供应商付款,7:放款]
     */
    @Column(name = "trade_sub_type")
    private String tradeSubType;

    /**
     * 币种
     */
    @Column(name = "cur_id")
    private String curId;

    /**
     * 交易金额
     */
    @Column(name = "trade_amt")
    private BigDecimal tradeAmt;

    /**
     * 出账金额
     */
    @Column(name = "out_amt")
    private BigDecimal outAmt;

    /**
     * 入账金额
     */
    @Column(name = "in_amt")
    private BigDecimal inAmt;

    /**
     * 交易时间
     */
    @Column(name = "trade_dts")
    private Date tradeDts;

    /**
     * 处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)
     */
    @Column(name = "process_status")
    private String processStatus;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsTrade other = (JsTrade) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getTradeNo() == null ? other.getTradeNo() == null : this.getTradeNo().equals(other.getTradeNo()))
            && (this.getAccType() == null ? other.getAccType() == null : this.getAccType().equals(other.getAccType()))
            && (this.getTradeType() == null ? other.getTradeType() == null : this.getTradeType().equals(other.getTradeType()))
            && (this.getInAcct() == null ? other.getInAcct() == null : this.getInAcct().equals(other.getInAcct()))
            && (this.getInAcctName() == null ? other.getInAcctName() == null : this.getInAcctName().equals(other.getInAcctName()))
            && (this.getOutAcct() == null ? other.getOutAcct() == null : this.getOutAcct().equals(other.getOutAcct()))
            && (this.getOutAcctName() == null ? other.getOutAcctName() == null : this.getOutAcctName().equals(other.getOutAcctName()))
            && (this.getTradeSubType() == null ? other.getTradeSubType() == null : this.getTradeSubType().equals(other.getTradeSubType()))
            && (this.getCurId() == null ? other.getCurId() == null : this.getCurId().equals(other.getCurId()))
            && (this.getTradeAmt() == null ? other.getTradeAmt() == null : this.getTradeAmt().equals(other.getTradeAmt()))
            && (this.getOutAmt() == null ? other.getOutAmt() == null : this.getOutAmt().equals(other.getOutAmt()))
            && (this.getInAmt() == null ? other.getInAmt() == null : this.getInAmt().equals(other.getInAmt()))
            && (this.getTradeDts() == null ? other.getTradeDts() == null : this.getTradeDts().equals(other.getTradeDts()))
            && (this.getProcessStatus() == null ? other.getProcessStatus() == null : this.getProcessStatus().equals(other.getProcessStatus()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getTradeNo() == null) ? 0 : getTradeNo().hashCode());
        result = prime * result + ((getAccType() == null) ? 0 : getAccType().hashCode());
        result = prime * result + ((getTradeType() == null) ? 0 : getTradeType().hashCode());
        result = prime * result + ((getInAcct() == null) ? 0 : getInAcct().hashCode());
        result = prime * result + ((getInAcctName() == null) ? 0 : getInAcctName().hashCode());
        result = prime * result + ((getOutAcct() == null) ? 0 : getOutAcct().hashCode());
        result = prime * result + ((getOutAcctName() == null) ? 0 : getOutAcctName().hashCode());
        result = prime * result + ((getTradeSubType() == null) ? 0 : getTradeSubType().hashCode());
        result = prime * result + ((getCurId() == null) ? 0 : getCurId().hashCode());
        result = prime * result + ((getTradeAmt() == null) ? 0 : getTradeAmt().hashCode());
        result = prime * result + ((getOutAmt() == null) ? 0 : getOutAmt().hashCode());
        result = prime * result + ((getInAmt() == null) ? 0 : getInAmt().hashCode());
        result = prime * result + ((getTradeDts() == null) ? 0 : getTradeDts().hashCode());
        result = prime * result + ((getProcessStatus() == null) ? 0 : getProcessStatus().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}