package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_sync_amazon_order_address")
public class JsSyncAmazonOrderAddress extends IBaseModel implements Serializable {
    /**
     * 用户 id
     */
    @Column(name = "user_natural_id")
    private String userNaturalId;

    /**
     * 名称
     */
    private String name;

    /**
     * 地址1
     */
    @Column(name = "address_line1")
    private String addressLine1;

    /**
     * 地址2
     */
    @Column(name = "address_line2")
    private String addressLine2;

    /**
     * 地址3
     */
    @Column(name = "address_line3")
    private String addressLine3;

    /**
     * 城市
     */
    private String city;

    /**
     * 郡、县
     */
    private String county;

    /**
     * 行政区
     */
    private String district;

    /**
     * 州或地区
     */
    @Column(name = "state_or_region")
    private String stateOrRegion;

    /**
     * 自治区或市
     */
    private String municipality;

    /**
     * 邮政编码
     */
    @Column(name = "postal_code")
    private String postalCode;

    /**
     * 国家代码
     */
    @Column(name = "country_code")
    private String countryCode;

    /**
     * 买家电话，亚马逊配送的订单无此值。
     */
    private String phone;

    /**
     * 地址类型
     */
    @Column(name = "address_type")
    private String addressType;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsSyncAmazonOrderAddress other = (JsSyncAmazonOrderAddress) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getUserNaturalId() == null ? other.getUserNaturalId() == null : this.getUserNaturalId().equals(other.getUserNaturalId()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getAddressLine1() == null ? other.getAddressLine1() == null : this.getAddressLine1().equals(other.getAddressLine1()))
            && (this.getAddressLine2() == null ? other.getAddressLine2() == null : this.getAddressLine2().equals(other.getAddressLine2()))
            && (this.getAddressLine3() == null ? other.getAddressLine3() == null : this.getAddressLine3().equals(other.getAddressLine3()))
            && (this.getCity() == null ? other.getCity() == null : this.getCity().equals(other.getCity()))
            && (this.getCounty() == null ? other.getCounty() == null : this.getCounty().equals(other.getCounty()))
            && (this.getDistrict() == null ? other.getDistrict() == null : this.getDistrict().equals(other.getDistrict()))
            && (this.getStateOrRegion() == null ? other.getStateOrRegion() == null : this.getStateOrRegion().equals(other.getStateOrRegion()))
            && (this.getMunicipality() == null ? other.getMunicipality() == null : this.getMunicipality().equals(other.getMunicipality()))
            && (this.getPostalCode() == null ? other.getPostalCode() == null : this.getPostalCode().equals(other.getPostalCode()))
            && (this.getCountryCode() == null ? other.getCountryCode() == null : this.getCountryCode().equals(other.getCountryCode()))
            && (this.getPhone() == null ? other.getPhone() == null : this.getPhone().equals(other.getPhone()))
            && (this.getAddressType() == null ? other.getAddressType() == null : this.getAddressType().equals(other.getAddressType()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getUserNaturalId() == null) ? 0 : getUserNaturalId().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getAddressLine1() == null) ? 0 : getAddressLine1().hashCode());
        result = prime * result + ((getAddressLine2() == null) ? 0 : getAddressLine2().hashCode());
        result = prime * result + ((getAddressLine3() == null) ? 0 : getAddressLine3().hashCode());
        result = prime * result + ((getCity() == null) ? 0 : getCity().hashCode());
        result = prime * result + ((getCounty() == null) ? 0 : getCounty().hashCode());
        result = prime * result + ((getDistrict() == null) ? 0 : getDistrict().hashCode());
        result = prime * result + ((getStateOrRegion() == null) ? 0 : getStateOrRegion().hashCode());
        result = prime * result + ((getMunicipality() == null) ? 0 : getMunicipality().hashCode());
        result = prime * result + ((getPostalCode() == null) ? 0 : getPostalCode().hashCode());
        result = prime * result + ((getCountryCode() == null) ? 0 : getCountryCode().hashCode());
        result = prime * result + ((getPhone() == null) ? 0 : getPhone().hashCode());
        result = prime * result + ((getAddressType() == null) ? 0 : getAddressType().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}