package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;

import com.js.common.enums.CurrEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_supplier_info")
public class JsPaySupplierInfo extends IBaseModel implements Serializable {

    /**
     * rcv_cur_type 收方币种类型 [1 大陆账户 2 香港账户 3 美国账户 4 欧洲账户 5 英国账户]
     */
    @Column(name = "rcv_cur_type")
    private CurrEnum rcvCurType;

    /**
     * 收款方账户类型 1-对公 2-对私
     */
    @Column(name = "bank_acc_type")
    private String bankAccType;

    /**
     * 收款方户名
     */
    @Column(name = "cus_name")
    private String cusName;

    /**
     * 收款方银行所在地（地区国家代码，如：HK、CN、JP）
     */
    @Column(name = "rcv_bank_country")
    private String rcvBankCountry;

    /**
     * 收款方银行卡号
     */
    @Column(name = "rcv_bank_card")
    private String rcvBankCard;

    /**
     * 收款银行名称
     */
    @Column(name = "rcv_bank_name")
    private String rcvBankName;

    /**
     * 开户省份
     */
    @Column(name = "rcv_bank_province")
    private String rcvBankProvince;

    /**
     * 开户城市
     */
    @Column(name = "rcv_bank_city")
    private String rcvBankCity;

    /**
     * 收款银行开户支行名称
     */
    @Column(name = "rcv_bank_subbranch")
    private String rcvBankSubbranch;

    /**
     * 收款方证件号
     */
    @Column(name = "rcv_credit_code")
    private String rcvCreditCode;

    /**
     * 收款方联系电话
     */
    @Column(name = "rcv_phone")
    private String rcvPhone;

    /**
     * 路由类型
     */
    @Column(name = "route_type")
    private String routeType;

    /**
     * 9位收款路线号码
     */
    @Column(name = "rcv_route_no")
    private String rcvRouteNo;

    /**
     * IBAN国际银行账号
     */
    private String iban;

    /**
     * SWIFT/BIC编码
     */
    @Column(name = "swift_bic")
    private String swiftBic;

    /**
     * Sort Code银行分类号码
     */
    @Column(name = "sort_code")
    private String sortCode;

    /**
     * 银行地址
     */
    @Column(name = "bank_addr")
    private String bankAddr;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySupplierInfo other = (JsPaySupplierInfo) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getRcvCurType() == null ? other.getRcvCurType() == null : this.getRcvCurType().equals(other.getRcvCurType()))
            && (this.getBankAccType() == null ? other.getBankAccType() == null : this.getBankAccType().equals(other.getBankAccType()))
            && (this.getCusName() == null ? other.getCusName() == null : this.getCusName().equals(other.getCusName()))
            && (this.getRcvBankCountry() == null ? other.getRcvBankCountry() == null : this.getRcvBankCountry().equals(other.getRcvBankCountry()))
            && (this.getRcvBankCard() == null ? other.getRcvBankCard() == null : this.getRcvBankCard().equals(other.getRcvBankCard()))
            && (this.getRcvBankName() == null ? other.getRcvBankName() == null : this.getRcvBankName().equals(other.getRcvBankName()))
            && (this.getRcvBankProvince() == null ? other.getRcvBankProvince() == null : this.getRcvBankProvince().equals(other.getRcvBankProvince()))
            && (this.getRcvBankCity() == null ? other.getRcvBankCity() == null : this.getRcvBankCity().equals(other.getRcvBankCity()))
            && (this.getRcvBankSubbranch() == null ? other.getRcvBankSubbranch() == null : this.getRcvBankSubbranch().equals(other.getRcvBankSubbranch()))
            && (this.getRcvCreditCode() == null ? other.getRcvCreditCode() == null : this.getRcvCreditCode().equals(other.getRcvCreditCode()))
            && (this.getRcvPhone() == null ? other.getRcvPhone() == null : this.getRcvPhone().equals(other.getRcvPhone()))
            && (this.getRouteType() == null ? other.getRouteType() == null : this.getRouteType().equals(other.getRouteType()))
            && (this.getRcvRouteNo() == null ? other.getRcvRouteNo() == null : this.getRcvRouteNo().equals(other.getRcvRouteNo()))
            && (this.getIban() == null ? other.getIban() == null : this.getIban().equals(other.getIban()))
            && (this.getSwiftBic() == null ? other.getSwiftBic() == null : this.getSwiftBic().equals(other.getSwiftBic()))
            && (this.getSortCode() == null ? other.getSortCode() == null : this.getSortCode().equals(other.getSortCode()))
            && (this.getBankAddr() == null ? other.getBankAddr() == null : this.getBankAddr().equals(other.getBankAddr()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getRcvCurType() == null) ? 0 : getRcvCurType().hashCode());
        result = prime * result + ((getBankAccType() == null) ? 0 : getBankAccType().hashCode());
        result = prime * result + ((getCusName() == null) ? 0 : getCusName().hashCode());
        result = prime * result + ((getRcvBankCountry() == null) ? 0 : getRcvBankCountry().hashCode());
        result = prime * result + ((getRcvBankCard() == null) ? 0 : getRcvBankCard().hashCode());
        result = prime * result + ((getRcvBankName() == null) ? 0 : getRcvBankName().hashCode());
        result = prime * result + ((getRcvBankProvince() == null) ? 0 : getRcvBankProvince().hashCode());
        result = prime * result + ((getRcvBankCity() == null) ? 0 : getRcvBankCity().hashCode());
        result = prime * result + ((getRcvBankSubbranch() == null) ? 0 : getRcvBankSubbranch().hashCode());
        result = prime * result + ((getRcvCreditCode() == null) ? 0 : getRcvCreditCode().hashCode());
        result = prime * result + ((getRcvPhone() == null) ? 0 : getRcvPhone().hashCode());
        result = prime * result + ((getRouteType() == null) ? 0 : getRouteType().hashCode());
        result = prime * result + ((getRcvRouteNo() == null) ? 0 : getRcvRouteNo().hashCode());
        result = prime * result + ((getIban() == null) ? 0 : getIban().hashCode());
        result = prime * result + ((getSwiftBic() == null) ? 0 : getSwiftBic().hashCode());
        result = prime * result + ((getSortCode() == null) ? 0 : getSortCode().hashCode());
        result = prime * result + ((getBankAddr() == null) ? 0 : getBankAddr().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}