package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "fadada_certi_company")
public class FadadaCertiCompany extends IBaseModel implements Serializable {
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 客户 id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 存证名称
     */
    @Column(name = "preservation_name")
    private String preservationName;

    /**
     * 存证数据提供方
     */
    @Column(name = "preservation_data_provider")
    private String preservationDataProvider;

    /**
     * 公司名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 证件类型
     */
    @Column(name = "document_type")
    private String documentType;

    /**
     * 统一社会信息代码
     */
    @Column(name = "credit_code")
    private String creditCode;

    /**
     * 营业职照照片路径
     */
    @Column(name = "credit_code_file")
    private String creditCodeFile;

    /**
     * 实名存证方式
     */
    @Column(name = "verified_mode")
    private String verifiedMode;

    /**
     * 己方银行支行
     */
    @Column(name = "public_branch_bank")
    private String publicBranchBank;

    /**
     * 己方银行账号
     */
    @Column(name = "public_bank_account")
    private String publicBankAccount;

    /**
     * 客户打款银行
     */
    @Column(name = "customer_bank")
    private String customerBank;

    /**
     * 客户银行支行
     */
    @Column(name = "customer_branch_bank")
    private String customerBranchBank;

    /**
     * 客户银行卡号
     */
    @Column(name = "customer_bank_account")
    private String customerBankAccount;

    /**
     * 打款类型
     */
    @Column(name = "pay_type")
    private String payType;

    /**
     * 企业负责人身份
     */
    @Column(name = "company_principal_type")
    private String companyPrincipalType;

    /**
     * 交易 id
     */
    @Column(name = "transaction_id")
    private String transactionId;

    /**
     * 申请编号
     */
    @Column(name = "apply_num")
    private String applyNum;

    /**
     * 认证类型
     */
    @Column(name = "verified_type")
    private String verifiedType;

    /**
     * 是否认证成功后自动申请实名证书
     */
    @Column(name = "cert_flag")
    private Boolean certFlag;

    /**
     * 存证编号，存证成功后由法大大返回
     */
    @Column(name = "evidence_no")
    private String evidenceNo;

    /**
     * 是否成功申请了证书
     */
    @Column(name = "apply_ca")
    private Boolean applyCa;

    /**
     * 企业法人名
     */
    private String name;

    /**
     * 法人身份证号
     */
    @Column(name = "id_card")
    private String idCard;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        FadadaCertiCompany other = (FadadaCertiCompany) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getCustomerId() == null ? other.getCustomerId() == null : this.getCustomerId().equals(other.getCustomerId()))
            && (this.getPreservationName() == null ? other.getPreservationName() == null : this.getPreservationName().equals(other.getPreservationName()))
            && (this.getPreservationDataProvider() == null ? other.getPreservationDataProvider() == null : this.getPreservationDataProvider().equals(other.getPreservationDataProvider()))
            && (this.getCompanyName() == null ? other.getCompanyName() == null : this.getCompanyName().equals(other.getCompanyName()))
            && (this.getDocumentType() == null ? other.getDocumentType() == null : this.getDocumentType().equals(other.getDocumentType()))
            && (this.getCreditCode() == null ? other.getCreditCode() == null : this.getCreditCode().equals(other.getCreditCode()))
            && (this.getCreditCodeFile() == null ? other.getCreditCodeFile() == null : this.getCreditCodeFile().equals(other.getCreditCodeFile()))
            && (this.getVerifiedMode() == null ? other.getVerifiedMode() == null : this.getVerifiedMode().equals(other.getVerifiedMode()))
            && (this.getPublicBranchBank() == null ? other.getPublicBranchBank() == null : this.getPublicBranchBank().equals(other.getPublicBranchBank()))
            && (this.getPublicBankAccount() == null ? other.getPublicBankAccount() == null : this.getPublicBankAccount().equals(other.getPublicBankAccount()))
            && (this.getCustomerBank() == null ? other.getCustomerBank() == null : this.getCustomerBank().equals(other.getCustomerBank()))
            && (this.getCustomerBranchBank() == null ? other.getCustomerBranchBank() == null : this.getCustomerBranchBank().equals(other.getCustomerBranchBank()))
            && (this.getCustomerBankAccount() == null ? other.getCustomerBankAccount() == null : this.getCustomerBankAccount().equals(other.getCustomerBankAccount()))
            && (this.getPayType() == null ? other.getPayType() == null : this.getPayType().equals(other.getPayType()))
            && (this.getCompanyPrincipalType() == null ? other.getCompanyPrincipalType() == null : this.getCompanyPrincipalType().equals(other.getCompanyPrincipalType()))
            && (this.getTransactionId() == null ? other.getTransactionId() == null : this.getTransactionId().equals(other.getTransactionId()))
            && (this.getApplyNum() == null ? other.getApplyNum() == null : this.getApplyNum().equals(other.getApplyNum()))
            && (this.getVerifiedType() == null ? other.getVerifiedType() == null : this.getVerifiedType().equals(other.getVerifiedType()))
            && (this.getCertFlag() == null ? other.getCertFlag() == null : this.getCertFlag().equals(other.getCertFlag()))
            && (this.getEvidenceNo() == null ? other.getEvidenceNo() == null : this.getEvidenceNo().equals(other.getEvidenceNo()))
            && (this.getApplyCa() == null ? other.getApplyCa() == null : this.getApplyCa().equals(other.getApplyCa()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getIdCard() == null ? other.getIdCard() == null : this.getIdCard().equals(other.getIdCard()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getCustomerId() == null) ? 0 : getCustomerId().hashCode());
        result = prime * result + ((getPreservationName() == null) ? 0 : getPreservationName().hashCode());
        result = prime * result + ((getPreservationDataProvider() == null) ? 0 : getPreservationDataProvider().hashCode());
        result = prime * result + ((getCompanyName() == null) ? 0 : getCompanyName().hashCode());
        result = prime * result + ((getDocumentType() == null) ? 0 : getDocumentType().hashCode());
        result = prime * result + ((getCreditCode() == null) ? 0 : getCreditCode().hashCode());
        result = prime * result + ((getCreditCodeFile() == null) ? 0 : getCreditCodeFile().hashCode());
        result = prime * result + ((getVerifiedMode() == null) ? 0 : getVerifiedMode().hashCode());
        result = prime * result + ((getPublicBranchBank() == null) ? 0 : getPublicBranchBank().hashCode());
        result = prime * result + ((getPublicBankAccount() == null) ? 0 : getPublicBankAccount().hashCode());
        result = prime * result + ((getCustomerBank() == null) ? 0 : getCustomerBank().hashCode());
        result = prime * result + ((getCustomerBranchBank() == null) ? 0 : getCustomerBranchBank().hashCode());
        result = prime * result + ((getCustomerBankAccount() == null) ? 0 : getCustomerBankAccount().hashCode());
        result = prime * result + ((getPayType() == null) ? 0 : getPayType().hashCode());
        result = prime * result + ((getCompanyPrincipalType() == null) ? 0 : getCompanyPrincipalType().hashCode());
        result = prime * result + ((getTransactionId() == null) ? 0 : getTransactionId().hashCode());
        result = prime * result + ((getApplyNum() == null) ? 0 : getApplyNum().hashCode());
        result = prime * result + ((getVerifiedType() == null) ? 0 : getVerifiedType().hashCode());
        result = prime * result + ((getCertFlag() == null) ? 0 : getCertFlag().hashCode());
        result = prime * result + ((getEvidenceNo() == null) ? 0 : getEvidenceNo().hashCode());
        result = prime * result + ((getApplyCa() == null) ? 0 : getApplyCa().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getIdCard() == null) ? 0 : getIdCard().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}